/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public abstract class StubSmartCard {
    boolean isPhysicalChannelOpen = false;
    Map<String, String> hexCommands = new ConcurrentHashMap<String, String>();

    public abstract byte[] getATR();

    public boolean isPhysicalChannelOpen() {
        return this.isPhysicalChannelOpen;
    }

    public void openPhysicalChannel() {
        this.isPhysicalChannelOpen = true;
    }

    public void closePhysicalChannel() {
        this.isPhysicalChannelOpen = false;
    }

    public abstract String getCardProtocol();

    public void addHexCommand(String command, String response) {
        if (command == null || response == null) {
            throw new IllegalArgumentException("Command and Response should not be null");
        }
        this.hexCommands.put(command.replace(" ", ""), response.replace(" ", ""));
    }

    public void removeHexCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException("Command should not be null");
        }
        this.hexCommands.remove(command.trim());
    }

    public byte[] processApdu(byte[] apduIn) {
        if (apduIn == null) {
            return null;
        }
        String hexApdu = ByteArrayUtil.toHex((byte[])apduIn);
        for (Map.Entry<String, String> hexCommand : this.hexCommands.entrySet()) {
            Pattern p = Pattern.compile(hexCommand.getKey());
            if (!p.matcher(hexApdu).matches()) continue;
            return ByteArrayUtil.fromHex((String)hexCommand.getValue());
        }
        throw new KeypleReaderIOException("No response available for this request: " + hexApdu);
    }
}

