/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalDuringProcessing;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleReaderException;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.service.exception.KeypleReaderProtocolNotSupportedException;
import org.eclipse.keyple.plugin.stub.StubProtocolSetting;
import org.eclipse.keyple.plugin.stub.StubReader;
import org.eclipse.keyple.plugin.stub.StubSmartCard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StubReaderImpl
extends AbstractObservableLocalReader
implements StubReader,
WaitForCardInsertionBlocking,
WaitForCardRemovalDuringProcessing,
WaitForCardRemovalBlocking {
    private static final Logger logger = LoggerFactory.getLogger(StubReaderImpl.class);
    private StubSmartCard card;
    private boolean isContactless = true;
    private final AtomicBoolean loopWaitCard = new AtomicBoolean();
    private final AtomicBoolean loopWaitCardRemoval = new AtomicBoolean();
    ReaderObservationExceptionHandler readerObservationExceptionHandler = new ReaderObservationExceptionHandler(){

        public void onReaderObservationError(String pluginName, String readerName, Throwable e) {
            logger.error("Unexpected exception {}:{}", new Object[]{pluginName, readerName, e});
        }
    };

    StubReaderImpl(String pluginName, String readerName) {
        super(pluginName, readerName);
    }

    StubReaderImpl(String pluginName, String readerName, boolean isContactless) {
        this(pluginName, readerName);
        this.isContactless = isContactless;
    }

    protected ReaderObservationExceptionHandler getObservationExceptionHandler() {
        return this.readerObservationExceptionHandler;
    }

    protected void onStartDetection() {
        logger.trace("Detection has been started on reader {}", (Object)this.getName());
    }

    protected void onStopDetection() {
        logger.trace("Detection has been stopped on reader {}", (Object)this.getName());
    }

    protected byte[] getATR() {
        return this.card.getATR();
    }

    protected boolean isPhysicalChannelOpen() {
        return this.card != null && this.card.isPhysicalChannelOpen();
    }

    protected void openPhysicalChannel() {
        if (this.card != null) {
            this.card.openPhysicalChannel();
        }
    }

    public void closePhysicalChannel() {
        if (this.card != null) {
            this.card.closePhysicalChannel();
        }
    }

    public byte[] transmitApdu(byte[] apduIn) {
        if (this.card == null) {
            throw new KeypleReaderIOException("No card available.");
        }
        return this.card.processApdu(apduIn);
    }

    protected boolean isCurrentProtocol(String readerProtocolName) {
        if (this.card != null && this.card.getCardProtocol() != null) {
            return this.card.getCardProtocol().equals(readerProtocolName);
        }
        return false;
    }

    protected synchronized boolean checkCardPresence() {
        return this.card != null;
    }

    protected final void activateReaderProtocol(String readerProtocolName) {
        if (!StubProtocolSetting.getSettings().containsKey(readerProtocolName)) {
            throw new KeypleReaderProtocolNotSupportedException(readerProtocolName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Activate protocol {} with rule \"{}\".", new Object[]{this.getName(), readerProtocolName, StubProtocolSetting.getSettings().get(readerProtocolName)});
        }
    }

    protected final void deactivateReaderProtocol(String readerProtocolName) {
        if (!StubProtocolSetting.getSettings().containsKey(readerProtocolName)) {
            throw new KeypleReaderProtocolNotSupportedException(readerProtocolName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Deactivate protocol {}.", (Object)this.getName(), (Object)readerProtocolName);
        }
    }

    public boolean isContactless() {
        return this.isContactless;
    }

    @Override
    public synchronized void insertCard(StubSmartCard smartCard) {
        logger.debug("Insert card {}", (Object)smartCard);
        if (this.isPhysicalChannelOpen()) {
            try {
                this.closePhysicalChannel();
            }
            catch (KeypleReaderException e) {
                logger.error("Error while closing channel reader", (Throwable)e);
            }
        }
        if (smartCard != null) {
            this.card = smartCard;
        }
    }

    @Override
    public synchronized void removeCard() {
        logger.debug("Remove card {}", this.card != null ? this.card : "none");
        this.card = null;
    }

    @Override
    public StubSmartCard getSmartcard() {
        return this.card;
    }

    public boolean waitForCardPresent() {
        this.loopWaitCard.set(true);
        while (this.loopWaitCard.get()) {
            if (this.checkCardPresence()) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.debug("Sleep was interrupted");
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public void stopWaitForCard() {
        this.loopWaitCard.set(false);
    }

    public boolean waitForCardAbsentNative() {
        this.loopWaitCardRemoval.set(true);
        while (this.loopWaitCardRemoval.get()) {
            if (!this.checkCardPresence()) {
                logger.trace("[{}] card removed", (Object)this.getName());
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.debug("Sleep was interrupted");
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public void stopWaitForCardRemoval() {
        this.loopWaitCardRemoval.set(false);
    }
}

