/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.event.PluginObservationExceptionHandler;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleAllocationNoReaderException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.plugin.stub.StubPluginFactory;
import org.eclipse.keyple.plugin.stub.StubPluginImpl;
import org.eclipse.keyple.plugin.stub.StubPoolPlugin;
import org.eclipse.keyple.plugin.stub.StubReaderImpl;
import org.eclipse.keyple.plugin.stub.StubSmartCard;

final class StubPoolPluginImpl
implements StubPoolPlugin {
    private final StubPluginImpl stubPlugin;
    private final Map<String, String> poolReaders;
    private final List<String> allocatedReaders;

    public StubPoolPluginImpl(String pluginName, PluginObservationExceptionHandler pluginObservationExceptionHandler, ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        this.stubPlugin = (StubPluginImpl)new StubPluginFactory(pluginName, pluginObservationExceptionHandler, readerObservationExceptionHandler).getPlugin();
        this.poolReaders = new ConcurrentHashMap<String, String>();
        this.allocatedReaders = new ArrayList<String>();
    }

    public String getName() {
        return this.stubPlugin.getName();
    }

    public SortedSet<String> getReaderGroupReferences() {
        return new TreeSet<String>(this.poolReaders.values());
    }

    @Override
    public Reader plugPoolReader(String groupReference, String readerName, StubSmartCard card) {
        Assert.getInstance().notNull((Object)groupReference, "group reference").notNull((Object)readerName, "reader name");
        this.stubPlugin.plugReader(readerName, true);
        StubReaderImpl newReader = (StubReaderImpl)this.stubPlugin.getReader(readerName);
        if (card != null) {
            newReader.insertCard(card);
        }
        this.poolReaders.put(newReader.getName(), groupReference);
        return newReader;
    }

    @Override
    public void unplugPoolReaders(String aGroupReference) {
        Assert.getInstance().notNull((Object)aGroupReference, "group reference");
        List<String> readerNames = this.listReadersByGroup(aGroupReference);
        for (String readerName : readerNames) {
            this.unplugPoolReader(readerName);
        }
    }

    @Override
    public void unplugPoolReader(String readerName) {
        Assert.getInstance().notNull((Object)readerName, "reader name");
        this.poolReaders.remove(readerName);
        this.allocatedReaders.remove(readerName);
        this.stubPlugin.unplugReader(readerName, true);
    }

    public Reader allocateReader(String aGroupReference) {
        Assert.getInstance().notNull((Object)aGroupReference, "group reference");
        List<String> readerNames = this.listReadersByGroup(aGroupReference);
        for (String readerName : readerNames) {
            if (this.allocatedReaders.contains(readerName)) continue;
            this.allocatedReaders.add(readerName);
            return this.stubPlugin.getReader(readerName);
        }
        throw new KeypleAllocationNoReaderException("No reader is available in the groupReference : " + aGroupReference);
    }

    public void releaseReader(Reader reader) {
        Assert.getInstance().notNull((Object)reader, "reader");
        if (!(reader instanceof StubReaderImpl)) {
            throw new IllegalArgumentException("Can not release reader, Reader should be of type StubReader");
        }
        StubReaderImpl stubReader = (StubReaderImpl)reader;
        if (stubReader.checkCardPresence()) {
            StubSmartCard card = stubReader.getSmartcard();
            stubReader.removeCard();
            stubReader.insertCard(card);
        }
        this.allocatedReaders.remove(reader.getName());
    }

    public Set<String> getReaderNames() {
        return this.stubPlugin.getReaderNames();
    }

    public Map<String, Reader> getReaders() {
        return this.stubPlugin.getReaders();
    }

    public Reader getReader(String name) {
        return this.stubPlugin.getReader(name);
    }

    Boolean isAllocated(String readerName) {
        return this.allocatedReaders.contains(readerName);
    }

    private List<String> listReadersByGroup(String aGroupReference) {
        ArrayList<String> readers = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.poolReaders.entrySet()) {
            String readerName = entry.getKey();
            String groupReference = entry.getValue();
            if (!groupReference.equals(aGroupReference)) continue;
            readers.add(readerName);
        }
        return readers;
    }
}

