/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.keyple.core.plugin.AbstractThreadedObservablePlugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.event.PluginObservationExceptionHandler;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.plugin.stub.StubPlugin;
import org.eclipse.keyple.plugin.stub.StubReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StubPluginImpl
extends AbstractThreadedObservablePlugin
implements StubPlugin {
    private static final Logger logger = LoggerFactory.getLogger(StubPluginImpl.class);
    private final SortedSet<String> connectedStubNames;
    private final PluginObservationExceptionHandler pluginObservationExceptionHandler;
    private final ReaderObservationExceptionHandler readerObservationExceptionHandler;

    StubPluginImpl(String pluginName, PluginObservationExceptionHandler pluginObservationExceptionHandler, ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        super(pluginName);
        this.threadWaitTimeout = 10L;
        this.connectedStubNames = new TreeSet<String>();
        this.pluginObservationExceptionHandler = pluginObservationExceptionHandler;
        this.readerObservationExceptionHandler = readerObservationExceptionHandler;
    }

    @Override
    public void plugReader(String readerName, Boolean synchronous) {
        this.plugReader(readerName, true, synchronous);
    }

    @Override
    public void plugReader(String readerName, boolean isContactless, Boolean synchronous) {
        if (this.connectedStubNames.contains(readerName)) {
            logger.error("Reader with readerName {} is already plugged", (Object)readerName);
            return;
        }
        this.connectedStubNames.add(readerName);
        if (synchronous.booleanValue()) {
            if (this.countObservers() == 0) {
                StubReaderImpl stubReader = new StubReaderImpl(this.getName(), readerName, isContactless);
                this.readers.put(readerName, stubReader);
            } else {
                while (!Thread.currentThread().isInterrupted() && !this.readers.keySet().contains(readerName)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Unexpected thread interruption.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        logger.info("Plugged a new reader with readerName:{} synchronously:{}", (Object)readerName, (Object)synchronous);
    }

    @Override
    public void plugReaders(Set<String> readerNames, Boolean synchronous) {
        logger.info("Plugging {} readers ..", (Object)readerNames.size());
        this.connectedStubNames.addAll(readerNames);
        if (synchronous.booleanValue()) {
            if (this.countObservers() == 0) {
                for (String readerName : readerNames) {
                    StubReaderImpl stubReader = new StubReaderImpl(this.getName(), readerName, true);
                    this.readers.put(readerName, stubReader);
                }
            } else {
                while (!Thread.currentThread().isInterrupted() && !this.readers.keySet().containsAll(readerNames)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Unexpected thread interruption.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        logger.info("Plugged new readers with readerNames:{} synchronously:{}", readerNames, (Object)synchronous);
    }

    @Override
    public void unplugReader(String readerName, Boolean synchronous) {
        if (!this.connectedStubNames.contains(readerName)) {
            logger.warn("No reader found with name {}", (Object)readerName);
            return;
        }
        this.connectedStubNames.remove(readerName);
        if (synchronous.booleanValue()) {
            if (this.countObservers() == 0) {
                Reader reader = (Reader)this.readers.get(readerName);
                this.readers.remove(readerName);
            } else {
                while (!Thread.currentThread().isInterrupted() && this.readers.keySet().contains(readerName)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Unexpected thread interruption.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        logger.info("Unplugged reader with name {}, remaining stub readers {}", (Object)readerName, (Object)this.connectedStubNames.size());
    }

    @Override
    public void unplugReaders(Set<String> readerNames, Boolean synchronous) {
        logger.trace("Unplug stub readers.. {}", readerNames);
        this.connectedStubNames.removeAll(readerNames);
        if (synchronous.booleanValue()) {
            if (this.countObservers() == 0) {
                for (String readerName : readerNames) {
                    Reader reader = (Reader)this.readers.get(readerName);
                    this.readers.remove(readerName);
                }
            } else {
                while (!Thread.currentThread().isInterrupted() && this.readers.keySet().containsAll(readerNames)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Unexpected thread interruption.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        logger.info("Unplugged readers with names {}, remaining stub readers {}", readerNames, (Object)this.connectedStubNames.size());
    }

    public SortedSet<String> fetchNativeReadersNames() {
        return this.connectedStubNames;
    }

    protected ConcurrentMap<String, Reader> initNativeReaders() {
        return new ConcurrentHashMap<String, Reader>();
    }

    protected Reader fetchNativeReader(String readerName) {
        Object reader = (Reader)this.readers.get(readerName);
        if (reader == null && this.connectedStubNames.contains(readerName)) {
            reader = new StubReaderImpl(this.getName(), readerName);
        }
        return reader;
    }

    protected PluginObservationExceptionHandler getObservationExceptionHandler() {
        return this.pluginObservationExceptionHandler;
    }
}

