/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionBlocking;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.plugin.pcsc.AbstractPcscReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PcscReaderImpl
extends AbstractPcscReader
implements WaitForCardInsertionBlocking {
    private static final Logger logger = LoggerFactory.getLogger(PcscReaderImpl.class);
    private static final long INSERT_LATENCY = 500L;
    private final AtomicBoolean loopWaitCard = new AtomicBoolean();

    protected PcscReaderImpl(String pluginName, CardTerminal terminal, ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        super(pluginName, terminal, readerObservationExceptionHandler);
    }

    public boolean waitForCardPresent() {
        logger.debug("[{}] waitForCardPresent => loop with latency of {} ms.", (Object)this.getName(), (Object)500L);
        this.loopWaitCard.set(true);
        try {
            while (this.loopWaitCard.get()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] waitForCardPresent => looping", (Object)this.getName());
                }
                if (this.terminal.waitForCardPresent(500L)) {
                    return true;
                }
                if (!Thread.interrupted()) continue;
                logger.debug("[{}] waitForCardPresent => task has been cancelled", (Object)this.getName());
                return false;
            }
            return false;
        }
        catch (CardException e) {
            throw new KeypleReaderIOException("[" + this.getName() + "] Exception occurred in waitForCardPresent. Message: " + e.getMessage());
        }
        catch (Throwable t) {
            logger.debug("[{}] waitForCardPresent => Throwable caught.", (Object)this.getName(), (Object)t);
            return false;
        }
    }

    public void stopWaitForCard() {
        this.loopWaitCard.set(false);
    }
}

