/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.plugin.pcsc.PcscSupportedContactProtocols;
import org.eclipse.keyple.plugin.pcsc.PcscSupportedContactlessProtocols;

final class PcscProtocolSetting {
    private static final Map<String, String> settings = new HashMap<String, String>();

    private PcscProtocolSetting() {
    }

    static void setProtocolIdentificationRule(String readerProtocolName, String rule) {
        Assert.getInstance().notEmpty(readerProtocolName, "readerProtocolName").notEmpty(rule, "rule");
        settings.put(readerProtocolName, rule);
    }

    static Map<String, String> getSettings() {
        return settings;
    }

    static {
        settings.put(PcscSupportedContactlessProtocols.ISO_14443_4.name(), "3B8880....................|3B8B80.*|3B8C800150.*|.*4F4D4141544C4153.*");
        settings.put(PcscSupportedContactlessProtocols.INNOVATRON_B_PRIME_CARD.name(), "3B8F8001805A0...................829000..");
        settings.put(PcscSupportedContactlessProtocols.MIFARE_ULTRA_LIGHT.name(), "3B8F8001804F0CA0000003060300030000000068");
        settings.put(PcscSupportedContactlessProtocols.MIFARE_CLASSIC.name(), "3B8F8001804F0CA000000306030001000000006A");
        settings.put(PcscSupportedContactlessProtocols.MIFARE_DESFIRE.name(), "3B8180018080");
        settings.put(PcscSupportedContactlessProtocols.MEMORY_ST25.name(), "3B8F8001804F0CA000000306070007D0020C00B6");
        settings.put(PcscSupportedContactProtocols.ISO_7816_3.name(), "3.*");
        settings.put(PcscSupportedContactProtocols.ISO_7816_3_T0.name(), "3.*");
        settings.put(PcscSupportedContactProtocols.ISO_7816_3_T1.name(), "3.*");
    }
}

