/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.plugin.pcsc.AbstractPcscPlugin;
import org.eclipse.keyple.plugin.pcsc.AbstractPcscReader;
import org.eclipse.keyple.plugin.pcsc.PcscReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PcscPluginWinImpl
extends AbstractPcscPlugin {
    private static final Logger logger = LoggerFactory.getLogger(PcscPluginWinImpl.class);
    private static volatile PcscPluginWinImpl instance;

    PcscPluginWinImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PcscPluginWinImpl getInstance() {
        if (instance != null) return instance;
        Class<PcscPluginWinImpl> clazz = PcscPluginWinImpl.class;
        synchronized (PcscPluginWinImpl.class) {
            if (instance != null) return instance;
            instance = new PcscPluginWinImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected CardTerminals getCardTerminals() {
        try {
            Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
            Field contextId = pcscterminal.getDeclaredField("contextId");
            contextId.setAccessible(true);
            if (contextId.getLong(pcscterminal) != 0L) {
                Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
                Method sCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
                sCardEstablishContext.setAccessible(true);
                Field sCardScopeUser = pcsc.getDeclaredField("SCARD_SCOPE_USER");
                sCardScopeUser.setAccessible(true);
                long newId = (Long)sCardEstablishContext.invoke(pcsc, sCardScopeUser.getInt(pcsc));
                contextId.setLong(pcscterminal, newId);
                TerminalFactory factory = TerminalFactory.getDefault();
                CardTerminals terminals = factory.terminals();
                Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
                fieldTerminals.setAccessible(true);
                ((Map)fieldTerminals.get(terminals)).clear();
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception.", (Throwable)e);
        }
        return TerminalFactory.getDefault().terminals();
    }

    @Override
    AbstractPcscReader createReader(String name, CardTerminal terminal, ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        return new PcscReaderImpl(name, terminal, readerObservationExceptionHandler);
    }
}

