/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.service.event.PluginObservationExceptionHandler;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeyplePluginInstantiationException;
import org.eclipse.keyple.plugin.pcsc.AbstractPcscPlugin;
import org.eclipse.keyple.plugin.pcsc.PcscPlugin;
import org.eclipse.keyple.plugin.pcsc.PcscPluginImpl;
import org.eclipse.keyple.plugin.pcsc.PcscPluginWinImpl;

public class PcscPluginFactory
implements PluginFactory {
    static final String PLUGIN_NAME = "PcscPlugin";
    private final PluginObservationExceptionHandler pluginObservationExceptionHandler;
    private final ReaderObservationExceptionHandler readerObservationExceptionHandler;
    private final boolean isOsWin;

    public PcscPluginFactory(PluginObservationExceptionHandler pluginObservationExceptionHandler, ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        this.pluginObservationExceptionHandler = pluginObservationExceptionHandler;
        this.readerObservationExceptionHandler = readerObservationExceptionHandler;
        this.isOsWin = System.getProperty("os.name").toLowerCase().contains("win");
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public PcscPlugin getPlugin() {
        try {
            AbstractPcscPlugin pcscPlugin = this.isOsWin ? PcscPluginWinImpl.getInstance() : PcscPluginImpl.getInstance();
            pcscPlugin.setPluginObservationExceptionHandler(this.pluginObservationExceptionHandler);
            pcscPlugin.setReaderObservationExceptionHandler(this.readerObservationExceptionHandler);
            return pcscPlugin;
        }
        catch (Exception e) {
            throw new KeyplePluginInstantiationException("Can not access smartcard.io readers", (Throwable)e);
        }
    }
}

