/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalDuringProcessing;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.service.exception.KeypleReaderProtocolNotSupportedException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.eclipse.keyple.plugin.pcsc.AbstractPcscPlugin;
import org.eclipse.keyple.plugin.pcsc.PcscProtocolSetting;
import org.eclipse.keyple.plugin.pcsc.PcscReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPcscReader
extends AbstractObservableLocalReader
implements PcscReader,
WaitForCardRemovalDuringProcessing,
WaitForCardRemovalBlocking {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPcscReader.class);
    protected final CardTerminal terminal;
    private final ReaderObservationExceptionHandler readerObservationExceptionHandler;
    private String parameterCardProtocol;
    private boolean cardExclusiveMode;
    private boolean cardReset;
    private Boolean isContactless;
    private Card card;
    private CardChannel channel;
    private static final long REMOVAL_LATENCY = 500L;
    private final AtomicBoolean loopWaitCardRemoval = new AtomicBoolean();

    protected AbstractPcscReader(String pluginName, CardTerminal terminal, ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        super(pluginName, terminal.getName());
        this.terminal = terminal;
        this.card = null;
        this.channel = null;
        this.parameterCardProtocol = PcscReader.IsoProtocol.ANY.getValue();
        this.cardExclusiveMode = true;
        this.cardReset = false;
        this.isContactless = null;
        this.readerObservationExceptionHandler = readerObservationExceptionHandler;
        logger.debug("[{}] constructor => using terminal ", (Object)terminal);
    }

    protected void onStartDetection() {
    }

    protected void onStopDetection() {
    }

    protected void closePhysicalChannel() {
        try {
            if (this.card != null) {
                logger.debug("[{}] closePhysicalChannel => closing the channel.", (Object)this.getName());
                this.channel = null;
                this.card.disconnect(this.cardReset);
                this.card = null;
            } else {
                logger.debug("[{}] closePhysicalChannel => card object is null.", (Object)this.getName());
            }
        }
        catch (CardException e) {
            throw new KeypleReaderIOException("Error while closing physical channel", (Throwable)e);
        }
    }

    protected boolean checkCardPresence() {
        try {
            return this.terminal.isCardPresent();
        }
        catch (CardException e) {
            throw new KeypleReaderIOException("Exception occurred in isCardPresent", (Throwable)e);
        }
    }

    public boolean waitForCardAbsentNative() {
        logger.debug("[{}] waitForCardAbsentNative => loop with latency of {} ms.", (Object)this.getName(), (Object)500L);
        this.loopWaitCardRemoval.set(true);
        try {
            while (this.loopWaitCardRemoval.get()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] waitForCardAbsentNative => looping", (Object)this.getName());
                }
                if (this.terminal.waitForCardAbsent(500L)) {
                    return true;
                }
                if (!Thread.interrupted()) continue;
                logger.debug("[{}] waitForCardAbsentNative => task has been cancelled", (Object)this.getName());
                return false;
            }
            return false;
        }
        catch (CardException e) {
            throw new KeypleReaderIOException("[" + this.getName() + "] Exception occurred in waitForCardAbsentNative. Message: " + e.getMessage());
        }
        catch (Throwable t) {
            logger.debug("[{}] waitForCardAbsentNative => Throwable caught.", (Object)this.getName(), (Object)t);
            return false;
        }
    }

    public void stopWaitForCardRemoval() {
        this.loopWaitCardRemoval.set(false);
    }

    protected byte[] transmitApdu(byte[] apduIn) {
        ResponseAPDU apduResponseData;
        if (this.channel != null) {
            try {
                apduResponseData = this.channel.transmit(new CommandAPDU(apduIn));
            }
            catch (CardException e) {
                throw new KeypleReaderIOException(this.getName() + ":" + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new KeypleReaderIOException(this.getName() + ":" + e.getMessage());
            }
        } else {
            throw new KeypleReaderIOException(this.getName() + ": null channel.");
        }
        return apduResponseData.getBytes();
    }

    protected void activateReaderProtocol(String readerProtocolName) {
        if (!PcscProtocolSetting.getSettings().containsKey(readerProtocolName)) {
            throw new KeypleReaderProtocolNotSupportedException(readerProtocolName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Activate protocol {} with rule \"{}\".", new Object[]{this.getName(), readerProtocolName, PcscProtocolSetting.getSettings().get(readerProtocolName)});
        }
    }

    protected void deactivateReaderProtocol(String readerProtocolName) {
        if (!PcscProtocolSetting.getSettings().containsKey(readerProtocolName)) {
            throw new KeypleReaderProtocolNotSupportedException(readerProtocolName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Deactivate protocol {}.", (Object)this.getName(), (Object)readerProtocolName);
        }
    }

    protected boolean isCurrentProtocol(String readerProtocolName) {
        String protocolRule = PcscProtocolSetting.getSettings().get(readerProtocolName);
        String atr = ByteArrayUtil.toHex((byte[])this.card.getATR().getBytes());
        return Pattern.compile(protocolRule).matcher(atr).matches();
    }

    @Override
    public PcscReader setSharingMode(PcscReader.SharingMode sharingMode) {
        Assert.getInstance().notNull((Object)sharingMode, "sharingMode");
        if (sharingMode == PcscReader.SharingMode.SHARED) {
            if (this.card != null) {
                try {
                    this.card.endExclusive();
                }
                catch (CardException e) {
                    throw new KeypleReaderIOException("Couldn't disable exclusive mode", (Throwable)e);
                }
            }
            this.cardExclusiveMode = false;
        } else if (sharingMode == PcscReader.SharingMode.EXCLUSIVE) {
            this.cardExclusiveMode = true;
        }
        return this;
    }

    @Override
    public PcscReader setContactless(boolean contactless) {
        this.isContactless = contactless;
        return this;
    }

    @Override
    public PcscReader setIsoProtocol(PcscReader.IsoProtocol isoProtocol) {
        Assert.getInstance().notNull((Object)isoProtocol, "isoProtocol");
        this.parameterCardProtocol = isoProtocol.getValue();
        return this;
    }

    @Override
    public PcscReader setDisconnectionMode(PcscReader.DisconnectionMode disconnectionMode) {
        Assert.getInstance().notNull((Object)disconnectionMode, "disconnectionMode");
        this.cardReset = disconnectionMode == PcscReader.DisconnectionMode.RESET;
        return this;
    }

    protected byte[] getATR() {
        return this.card.getATR().getBytes();
    }

    protected boolean isPhysicalChannelOpen() {
        return this.card != null;
    }

    protected void openPhysicalChannel() {
        try {
            if (this.card == null) {
                this.card = this.terminal.connect(this.parameterCardProtocol);
                if (this.cardExclusiveMode) {
                    this.card.beginExclusive();
                    logger.debug("[{}] Opening of a card physical channel in exclusive mode.", (Object)this.getName());
                } else {
                    logger.debug("[{}] Opening of a card physical channel in shared mode.", (Object)this.getName());
                }
            }
            this.channel = this.card.getBasicChannel();
        }
        catch (CardException e) {
            throw new KeypleReaderIOException("Error while opening Physical Channel", (Throwable)e);
        }
    }

    public boolean isContactless() {
        if (this.isContactless == null) {
            this.isContactless = ((AbstractPcscPlugin)SmartCardService.getInstance().getPlugin(this.getPluginName())).isContactless(this.getName());
        }
        return this.isContactless;
    }

    protected ReaderObservationExceptionHandler getObservationExceptionHandler() {
        return this.readerObservationExceptionHandler;
    }
}

