/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import org.eclipse.keyple.core.plugin.AbstractThreadedObservablePlugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.event.PluginObservationExceptionHandler;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.plugin.pcsc.AbstractPcscReader;
import org.eclipse.keyple.plugin.pcsc.PcscPlugin;
import org.eclipse.keyple.plugin.pcsc.PcscProtocolSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPcscPlugin
extends AbstractThreadedObservablePlugin
implements PcscPlugin {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPcscPlugin.class);
    private String contactReaderRegexFilter = "";
    private String contactlessReaderRegexFilter = "";
    private PluginObservationExceptionHandler pluginObservationExceptionHandler;
    private ReaderObservationExceptionHandler readerObservationExceptionHandler;

    protected AbstractPcscPlugin() {
        super("PcscPlugin");
    }

    public SortedSet<String> fetchNativeReadersNames() {
        ConcurrentSkipListSet<String> nativeReadersNames = new ConcurrentSkipListSet<String>();
        CardTerminals terminals = this.getCardTerminals();
        try {
            for (CardTerminal terminal : terminals.list()) {
                nativeReadersNames.add(terminal.getName());
            }
        }
        catch (CardException e) {
            if (e.getCause().toString().contains("SCARD_E_NO_READERS_AVAILABLE")) {
                logger.trace("No reader available.");
            }
            logger.trace("[{}] fetchNativeReadersNames => Terminal list is not accessible. Exception: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new KeypleReaderIOException("Could not access terminals list", (Throwable)e);
        }
        return nativeReadersNames;
    }

    abstract AbstractPcscReader createReader(String var1, CardTerminal var2, ReaderObservationExceptionHandler var3);

    protected Map<String, Reader> initNativeReaders() {
        ConcurrentHashMap<String, Reader> nativeReaders = new ConcurrentHashMap<String, Reader>();
        CardTerminals terminals = this.getCardTerminals();
        logger.trace("[{}] initNativeReaders => CardTerminal in list: {}", (Object)this.getName(), (Object)terminals);
        try {
            for (CardTerminal terminal : terminals.list()) {
                AbstractPcscReader pcscReader = this.createReader(this.getName(), terminal, this.readerObservationExceptionHandler);
                nativeReaders.put(pcscReader.getName(), (Reader)pcscReader);
            }
        }
        catch (CardException e) {
            if (e.getCause().toString().contains("SCARD_E_NO_READERS_AVAILABLE")) {
                logger.trace("No reader available.");
            }
            logger.trace("[{}] Terminal list is not accessible. Exception: {}", (Object)this.getName(), (Object)e.getMessage());
        }
        return nativeReaders;
    }

    protected Reader fetchNativeReader(String name) {
        Object reader = (Reader)this.readers.get(name);
        if (reader != null) {
            return reader;
        }
        CardTerminals terminals = this.getCardTerminals();
        try {
            for (CardTerminal terminal : terminals.list()) {
                if (!terminal.getName().equals(name)) continue;
                logger.trace("[{}] fetchNativeReader => CardTerminal in new PcscReader: {}", (Object)this.getName(), (Object)terminals);
                reader = this.createReader(this.getName(), terminal, this.readerObservationExceptionHandler);
            }
        }
        catch (CardException e) {
            throw new KeypleReaderIOException("Could not access terminals list", (Throwable)e);
        }
        if (reader == null) {
            throw new KeypleReaderNotFoundException("Reader " + name + " not found!");
        }
        return reader;
    }

    protected abstract CardTerminals getCardTerminals();

    @Override
    public void setReaderNameFilter(boolean contactlessMode, String readerNameFilter) {
        Assert.getInstance().notEmpty(readerNameFilter, "readerNameFilter");
        if (contactlessMode) {
            this.contactlessReaderRegexFilter = readerNameFilter;
        } else {
            this.contactReaderRegexFilter = readerNameFilter;
        }
    }

    @Override
    public void setProtocolIdentificationRule(String readerProtocolName, String protocolRule) {
        PcscProtocolSetting.setProtocolIdentificationRule(readerProtocolName, protocolRule);
    }

    boolean isContactless(String readerName) {
        Pattern p = Pattern.compile(this.contactReaderRegexFilter);
        if (p.matcher(readerName).matches()) {
            return false;
        }
        p = Pattern.compile(this.contactlessReaderRegexFilter);
        if (p.matcher(readerName).matches()) {
            return true;
        }
        throw new IllegalStateException("Unable to determine the transmission mode for reader " + readerName);
    }

    void setPluginObservationExceptionHandler(PluginObservationExceptionHandler pluginObservationExceptionHandler) {
        this.pluginObservationExceptionHandler = pluginObservationExceptionHandler;
    }

    void setReaderObservationExceptionHandler(ReaderObservationExceptionHandler readerObservationExceptionHandler) {
        this.readerObservationExceptionHandler = readerObservationExceptionHandler;
    }

    protected PluginObservationExceptionHandler getObservationExceptionHandler() {
        return this.pluginObservationExceptionHandler;
    }
}

