/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AsyncNodeServer;
import org.eclipse.keyple.distributed.RemotePluginServer;
import org.eclipse.keyple.distributed.SyncNodeServer;
import org.eclipse.keyple.distributed.impl.RemotePluginServerImpl;

public final class RemotePluginServerUtils {
    private static final String PLUGIN_NAME = "pluginName";

    private RemotePluginServerUtils() {
    }

    public static RemotePluginServer getRemotePlugin() {
        return RemotePluginServerUtils.getRemotePlugin("DefaultRemotePluginServer");
    }

    public static RemotePluginServer getRemotePlugin(String pluginName) {
        Assert.getInstance().notNull((Object)pluginName, PLUGIN_NAME);
        return (RemotePluginServer)SmartCardService.getInstance().getPlugin(pluginName);
    }

    public static AsyncNodeServer getAsyncNode() {
        return RemotePluginServerUtils.getAsyncNode("DefaultRemotePluginServer");
    }

    public static AsyncNodeServer getAsyncNode(String pluginName) {
        Assert.getInstance().notNull((Object)pluginName, PLUGIN_NAME);
        RemotePluginServerImpl plugin = (RemotePluginServerImpl)RemotePluginServerUtils.getRemotePlugin(pluginName);
        if (plugin.node instanceof AsyncNodeServer) {
            return (AsyncNodeServer)plugin.node;
        }
        throw new IllegalStateException("The RemotePluginServer is not configured with a AsyncNodeServer");
    }

    public static SyncNodeServer getSyncNode() {
        return RemotePluginServerUtils.getSyncNode("DefaultRemotePluginServer");
    }

    public static SyncNodeServer getSyncNode(String pluginName) {
        Assert.getInstance().notNull((Object)pluginName, PLUGIN_NAME);
        RemotePluginServerImpl plugin = (RemotePluginServerImpl)RemotePluginServerUtils.getRemotePlugin(pluginName);
        if (plugin.node instanceof SyncNodeServer) {
            return (SyncNodeServer)plugin.node;
        }
        throw new IllegalStateException("The RemotePluginServer is not configured with a SyncNodeServer");
    }
}

