/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.event.ObservablePlugin;
import org.eclipse.keyple.core.service.event.PluginEvent;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.ObservableRemoteReaderServer;
import org.eclipse.keyple.distributed.RemotePluginServer;
import org.eclipse.keyple.distributed.RemoteReaderServer;
import org.eclipse.keyple.distributed.impl.AbstractRemotePlugin;
import org.eclipse.keyple.distributed.impl.AbstractRemoteReaderServer;
import org.eclipse.keyple.distributed.impl.ObservableRemoteReaderImpl;
import org.eclipse.keyple.distributed.impl.ObservableRemoteReaderServerImpl;
import org.eclipse.keyple.distributed.impl.RemoteReaderImpl;
import org.eclipse.keyple.distributed.impl.RemoteReaderServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemotePluginServerImpl
extends AbstractRemotePlugin
implements RemotePluginServer {
    private static final Logger logger = LoggerFactory.getLogger(RemotePluginServerImpl.class);
    private static final String USER_INPUT_DATA = "userInputData";
    private final ExecutorService eventNotificationPool;
    private final List<ObservablePlugin.PluginObserver> observers;

    RemotePluginServerImpl(String name, ExecutorService eventNotificationPool) {
        super(name);
        this.eventNotificationPool = eventNotificationPool;
        this.observers = new ArrayList<ObservablePlugin.PluginObserver>();
    }

    ConcurrentMap<String, Reader> initNativeReaders() {
        return new ConcurrentHashMap<String, Reader>();
    }

    void onMessage(MessageDto message) {
        switch (MessageDto.Action.valueOf((String)message.getAction())) {
            case EXECUTE_REMOTE_SERVICE: {
                AbstractRemoteReaderServer remoteReader = this.createMasterReader(message);
                this.readers.put(remoteReader.getName(), remoteReader);
                this.notifyObservers(new PluginEvent(this.getName(), remoteReader.getName(), PluginEvent.EventType.READER_CONNECTED));
                break;
            }
            case READER_EVENT: {
                Assert.getInstance().notNull((Object)message.getRemoteReaderName(), "remoteReaderName");
                ObservableRemoteReaderServerImpl delegateRemoteReader = this.createSlaveReader(message);
                this.readers.put(delegateRemoteReader.getName(), delegateRemoteReader);
                ReaderEvent readerEvent = (ReaderEvent)KeypleGsonParser.getParser().fromJson(((JsonObject)KeypleGsonParser.getParser().fromJson(message.getBody(), JsonObject.class)).get("readerEvent"), ReaderEvent.class);
                delegateRemoteReader.notifyObservers(new ReaderEvent(this.getName(), delegateRemoteReader.getName(), readerEvent.getEventType(), readerEvent.getDefaultSelectionsResponse()));
                break;
            }
            default: {
                throw new IllegalStateException("Message is not supported by Remote Plugin " + message);
            }
        }
    }

    @Override
    public void terminateService(String remoteReaderName, Object userOutputData) {
        AbstractRemoteReaderServer remoteReader = (AbstractRemoteReaderServer)this.getReader(remoteReaderName);
        boolean unregisterRemoteReader = false;
        if (!(remoteReader instanceof ObservableRemoteReaderServer)) {
            unregisterRemoteReader = true;
            this.readers.remove(remoteReader.getName());
        } else {
            ObservableRemoteReaderServerImpl observableReader = (ObservableRemoteReaderServerImpl)remoteReader;
            if (observableReader.getMasterReader() != null) {
                this.readers.remove(remoteReader.getName());
                if (observableReader.countObservers() == 0) {
                    this.readers.remove(observableReader.getMasterReader().getName());
                    unregisterRemoteReader = true;
                }
            } else if (observableReader.countObservers() == 0) {
                this.readers.remove(remoteReader.getName());
                unregisterRemoteReader = true;
            }
        }
        JsonObject body = new JsonObject();
        body.addProperty("userOutputData", KeypleGsonParser.getParser().toJson(userOutputData));
        body.addProperty("unregisterRemoteReader", Boolean.valueOf(unregisterRemoteReader));
        MessageDto message = new MessageDto().setAction(MessageDto.Action.TERMINATE_SERVICE.name()).setRemoteReaderName(remoteReaderName).setSessionId(remoteReader.getSessionId()).setClientNodeId(remoteReader.getClientNodeId()).setBody(body.toString());
        this.node.sendMessage(message);
    }

    @Override
    public RemoteReaderServer getReader(String name) {
        Assert.getInstance().notNull((Object)name, "reader name");
        RemoteReaderServer seReader = (RemoteReaderServer)this.readers.get(name);
        if (seReader == null) {
            throw new KeypleReaderNotFoundException(name);
        }
        return seReader;
    }

    public void addObserver(ObservablePlugin.PluginObserver observer) {
        Assert.getInstance().notNull((Object)observer, "Plugin Observer");
        this.observers.add(observer);
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Added plugin observer '{}'", (Object)this.getName(), (Object)observer.getClass().getSimpleName());
        }
    }

    public void removeObserver(ObservablePlugin.PluginObserver observer) {
        Assert.getInstance().notNull((Object)observer, "Plugin Observer");
        if (this.observers.remove(observer) && logger.isTraceEnabled()) {
            logger.trace("[{}] Removed plugin observer '{}'", (Object)this.getName(), (Object)observer.getClass().getSimpleName());
        }
    }

    public void clearObservers() {
        this.observers.clear();
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Clear reader observers", (Object)this.getName());
        }
    }

    public int countObservers() {
        return this.observers.size();
    }

    private void notifyObservers(final PluginEvent event) {
        for (final ObservablePlugin.PluginObserver observer : this.observers) {
            this.eventNotificationPool.execute(new Runnable(){

                @Override
                public void run() {
                    observer.update(event);
                }
            });
        }
    }

    private AbstractRemoteReaderServer createMasterReader(MessageDto message) {
        JsonObject body = (JsonObject)KeypleGsonParser.getParser().fromJson(message.getBody(), JsonObject.class);
        String serviceId = body.get("serviceId").getAsString();
        String userInputData = body.has(USER_INPUT_DATA) ? body.get(USER_INPUT_DATA).toString() : null;
        String initialCardContent = body.has("initialCardContent") ? body.get("initialCardContent").toString() : null;
        boolean isObservable = body.has("isObservable") && body.get("isObservable").getAsBoolean();
        String remoteReaderName = UUID.randomUUID().toString();
        String sessionId = message.getSessionId();
        String clientNodeId = message.getClientNodeId();
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Create a remote reader {} with serviceId:{} and isObservable:{} for sessionId:{} for clientNodeId:{}", new Object[]{this.getName(), remoteReaderName, serviceId, isObservable, sessionId, clientNodeId});
        }
        if (isObservable) {
            ObservableRemoteReaderImpl observableRemoteReaderImpl = new ObservableRemoteReaderImpl(this.getName(), remoteReaderName, this.node, sessionId, clientNodeId, this.eventNotificationPool);
            return new ObservableRemoteReaderServerImpl(observableRemoteReaderImpl, serviceId, userInputData, initialCardContent, null);
        }
        RemoteReaderImpl remoteReaderImpl = new RemoteReaderImpl(this.getName(), remoteReaderName, this.node, sessionId, clientNodeId);
        return new RemoteReaderServerImpl(remoteReaderImpl, serviceId, userInputData, initialCardContent);
    }

    private ObservableRemoteReaderServerImpl createSlaveReader(MessageDto message) {
        ObservableRemoteReaderServerImpl observableRemoteReaderServer = (ObservableRemoteReaderServerImpl)this.getReader(message.getRemoteReaderName());
        JsonObject body = (JsonObject)KeypleGsonParser.getParser().fromJson(message.getBody(), JsonObject.class);
        String userInputData = body.has(USER_INPUT_DATA) ? body.get(USER_INPUT_DATA).toString() : null;
        ObservableRemoteReaderImpl observableRemoteReader = new ObservableRemoteReaderImpl(this.getName(), UUID.randomUUID().toString(), this.node, message.getSessionId(), message.getClientNodeId(), this.eventNotificationPool);
        return new ObservableRemoteReaderServerImpl(observableRemoteReader, null, userInputData, null, observableRemoteReaderServer);
    }
}

