/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.service.event.ObservablePlugin;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.RemotePluginServer;
import org.eclipse.keyple.distributed.impl.RemotePluginServerImpl;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemotePluginServerFactory
implements PluginFactory {
    private static final Logger logger = LoggerFactory.getLogger(RemotePluginServerFactory.class);
    static final String DEFAULT_PLUGIN_NAME = "DefaultRemotePluginServer";
    private RemotePluginServer plugin;

    private RemotePluginServerFactory(RemotePluginServer plugin) {
        this.plugin = plugin;
    }

    public static NameStep builder() {
        return new Builder();
    }

    public String getPluginName() {
        return this.plugin.getName();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    private static class Builder
    implements NameStep,
    NodeStep,
    PluginObserverStep,
    EventNotificationPoolStep,
    BuilderStep {
        private AsyncEndpointServer asyncEndpoint;
        private ExecutorService eventNotificationPool;
        private ObservablePlugin.PluginObserver observer;
        private String pluginName;

        private Builder() {
        }

        @Override
        public NodeStep withPluginName(String pluginName) {
            Assert.getInstance().notNull((Object)pluginName, "pluginName");
            this.pluginName = pluginName;
            return this;
        }

        @Override
        public NodeStep withDefaultPluginName() {
            this.pluginName = RemotePluginServerFactory.DEFAULT_PLUGIN_NAME;
            return this;
        }

        @Override
        public PluginObserverStep withAsyncNode(AsyncEndpointServer endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.asyncEndpoint = endpoint;
            return this;
        }

        @Override
        public PluginObserverStep withSyncNode() {
            return this;
        }

        @Override
        public EventNotificationPoolStep withPluginObserver(ObservablePlugin.PluginObserver observer) {
            Assert.getInstance().notNull((Object)observer, "observer");
            this.observer = observer;
            return this;
        }

        @Override
        public BuilderStep usingDefaultEventNotificationPool() {
            this.eventNotificationPool = Executors.newCachedThreadPool();
            return this;
        }

        @Override
        public BuilderStep usingEventNotificationPool(ExecutorService eventNotificationPool) {
            Assert.getInstance().notNull((Object)eventNotificationPool, "eventNotificationPool");
            this.eventNotificationPool = eventNotificationPool;
            return this;
        }

        @Override
        public RemotePluginServerFactory build() {
            RemotePluginServerImpl plugin = new RemotePluginServerImpl(this.pluginName, this.eventNotificationPool);
            if (this.asyncEndpoint != null) {
                logger.info("Create a new RemotePluginServer with a AsyncNodeServer");
                plugin.bindAsyncNodeServer(this.asyncEndpoint);
            } else {
                logger.info("Create a new RemotePluginServer with a SyncNodeServer");
                plugin.bindSyncNodeServer();
            }
            plugin.addObserver(this.observer);
            return new RemotePluginServerFactory(plugin);
        }
    }

    public static interface BuilderStep {
        public RemotePluginServerFactory build();
    }

    public static interface EventNotificationPoolStep {
        public BuilderStep usingDefaultEventNotificationPool();

        public BuilderStep usingEventNotificationPool(ExecutorService var1);
    }

    public static interface PluginObserverStep {
        public EventNotificationPoolStep withPluginObserver(ObservablePlugin.PluginObserver var1);
    }

    public static interface NodeStep {
        public PluginObserverStep withAsyncNode(AsyncEndpointServer var1);

        public PluginObserverStep withSyncNode();
    }

    public static interface NameStep {
        public NodeStep withPluginName(String var1);

        public NodeStep withDefaultPluginName();
    }
}

