/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.PoolRemotePluginClient;
import org.eclipse.keyple.distributed.impl.AbstractRemotePlugin;
import org.eclipse.keyple.distributed.impl.RemoteReaderImpl;

final class PoolRemotePluginClientImpl
extends AbstractRemotePlugin
implements PoolRemotePluginClient {
    PoolRemotePluginClientImpl(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getReaderGroupReferences() {
        String sessionId = this.generateSessionId();
        try {
            this.node.openSession(sessionId);
            MessageDto request = new MessageDto().setAction(MessageDto.Action.GET_READER_GROUP_REFERENCES.name()).setSessionId(sessionId).setBody(null);
            MessageDto response = this.node.sendRequest(request);
            this.checkError(response);
            String readerGroupReferencesJson = ((JsonObject)KeypleGsonParser.getParser().fromJson(response.getBody(), JsonObject.class)).get("readerGroupReferences").toString();
            SortedSet sortedSet = (SortedSet)KeypleGsonParser.getParser().fromJson(readerGroupReferencesJson, SortedSet.class);
            return sortedSet;
        }
        finally {
            this.node.closeSessionSilently(sessionId);
        }
    }

    public Reader allocateReader(String groupReference) {
        String sessionId = this.generateSessionId();
        try {
            this.node.openSession(sessionId);
            JsonObject body = new JsonObject();
            body.addProperty("groupReference", groupReference);
            MessageDto request = new MessageDto().setAction(MessageDto.Action.ALLOCATE_READER.name()).setSessionId(sessionId).setBody(body.toString());
            MessageDto response = this.node.sendRequest(request);
            this.checkError(response);
            RemoteReaderImpl reader = new RemoteReaderImpl(this.getName(), response.getLocalReaderName(), this.node, sessionId, response.getClientNodeId());
            this.readers.put(reader.getName(), reader);
            return reader;
        }
        catch (RuntimeException e) {
            this.node.closeSessionSilently(sessionId);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReader(Reader reader) {
        Assert.getInstance().notNull((Object)reader, "reader");
        if (!this.readers.containsKey(reader.getName())) {
            throw new IllegalArgumentException("reader is not a remote reader of this pool plugin");
        }
        RemoteReaderImpl remoteReaderImpl = (RemoteReaderImpl)reader;
        try {
            MessageDto request = new MessageDto().setAction(MessageDto.Action.RELEASE_READER.name()).setRemoteReaderName(reader.getName()).setLocalReaderName(remoteReaderImpl.getLocalReaderName()).setSessionId(remoteReaderImpl.getSessionId()).setBody(null);
            this.readers.remove(reader.getName());
            MessageDto response = this.node.sendRequest(request);
            this.checkError(response);
        }
        finally {
            this.node.closeSessionSilently(remoteReaderImpl.getSessionId());
        }
    }

    public Reader getReader(String name) {
        Assert.getInstance().notNull((Object)name, "reader name");
        Reader seReader = (Reader)this.readers.get(name);
        if (seReader == null) {
            throw new KeypleReaderNotFoundException(name);
        }
        return seReader;
    }

    void onMessage(MessageDto msg) {
        throw new UnsupportedOperationException("onMessage method is not supported by this plugin");
    }

    @Override
    Map<String, Reader> initNativeReaders() {
        return new ConcurrentHashMap<String, Reader>();
    }
}

