/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.PoolRemotePluginClient;
import org.eclipse.keyple.distributed.impl.PoolRemotePluginClientImpl;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClient;
import org.eclipse.keyple.distributed.spi.SyncEndpointClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoolRemotePluginClientFactory
implements PluginFactory {
    private static final Logger logger = LoggerFactory.getLogger(PoolRemotePluginClientFactory.class);
    static final String DEFAULT_PLUGIN_NAME = "DefaultPoolRemotePluginClient";
    private static final int DEFAULT_TIMEOUT = 5;
    private final PoolRemotePluginClient plugin;

    private PoolRemotePluginClientFactory(PoolRemotePluginClient plugin) {
        this.plugin = plugin;
    }

    public static NameStep builder() {
        return new Builder();
    }

    public String getPluginName() {
        return this.plugin.getName();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    private static class Builder
    implements NameStep,
    NodeStep,
    BuilderStep,
    TimeoutStep {
        private AsyncEndpointClient asyncEndpoint;
        private SyncEndpointClient syncEndpoint;
        private int timeoutInSec;
        private String pluginName;

        private Builder() {
        }

        @Override
        public NodeStep withPluginName(String pluginName) {
            Assert.getInstance().notNull((Object)pluginName, "pluginName");
            this.pluginName = pluginName;
            return this;
        }

        @Override
        public NodeStep withDefaultPluginName() {
            this.pluginName = PoolRemotePluginClientFactory.DEFAULT_PLUGIN_NAME;
            return this;
        }

        @Override
        public TimeoutStep withAsyncNode(AsyncEndpointClient endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.asyncEndpoint = endpoint;
            return this;
        }

        @Override
        public BuilderStep withSyncNode(SyncEndpointClient endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.syncEndpoint = endpoint;
            return this;
        }

        @Override
        public BuilderStep usingDefaultTimeout() {
            this.timeoutInSec = 5;
            return this;
        }

        @Override
        public BuilderStep usingTimeout(int timeoutInSeconds) {
            this.timeoutInSec = timeoutInSeconds;
            return this;
        }

        @Override
        public PoolRemotePluginClientFactory build() {
            PoolRemotePluginClientImpl plugin = new PoolRemotePluginClientImpl(this.pluginName);
            if (this.asyncEndpoint != null) {
                logger.info("Create a new PoolRemotePluginClient with a AsyncNodeClient");
                plugin.bindAsyncNodeClient(this.asyncEndpoint, this.timeoutInSec);
            } else {
                logger.info("Create a new PoolRemotePluginClient with a SyncNodeClient");
                plugin.bindSyncNodeClient(this.syncEndpoint, null, null);
            }
            return new PoolRemotePluginClientFactory(plugin);
        }
    }

    public static interface BuilderStep {
        public PoolRemotePluginClientFactory build();
    }

    public static interface TimeoutStep {
        public BuilderStep usingDefaultTimeout();

        public BuilderStep usingTimeout(int var1);
    }

    public static interface NodeStep {
        public TimeoutStep withAsyncNode(AsyncEndpointClient var1);

        public BuilderStep withSyncNode(SyncEndpointClient var1);
    }

    public static interface NameStep {
        public NodeStep withPluginName(String var1);

        public NodeStep withDefaultPluginName();
    }
}

