/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.plugin.ObservableReaderNotifier;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsRequest;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.ObservableRemoteReaderServer;
import org.eclipse.keyple.distributed.impl.AbstractRemoteReaderServer;
import org.eclipse.keyple.distributed.impl.ObservableRemoteReaderImpl;

final class ObservableRemoteReaderServerImpl
extends AbstractRemoteReaderServer
implements ObservableRemoteReaderServer,
ObservableReaderNotifier {
    private final ObservableRemoteReaderImpl reader;
    private final ObservableRemoteReaderServerImpl masterReader;

    ObservableRemoteReaderServerImpl(ObservableRemoteReaderImpl reader, String serviceId, String userInputDataJson, String initialCardContentJson, ObservableRemoteReaderServerImpl masterReader) {
        super(reader, serviceId, userInputDataJson, initialCardContentJson);
        this.reader = reader;
        this.masterReader = masterReader;
    }

    public void notifyObservers(ReaderEvent event) {
        if (this.masterReader != null) {
            this.masterReader.notifyObservers(event);
        } else {
            this.reader.notifyObservers(event);
        }
    }

    public void addObserver(ObservableReader.ReaderObserver observer) {
        Assert.getInstance().notNull((Object)observer, "observer");
        if (this.masterReader != null) {
            this.masterReader.addObserver(observer);
        } else {
            this.reader.addObserver(observer);
        }
    }

    public void removeObserver(ObservableReader.ReaderObserver observer) {
        Assert.getInstance().notNull((Object)observer, "observer");
        if (this.masterReader != null) {
            this.masterReader.removeObserver(observer);
        } else {
            this.reader.removeObserver(observer);
        }
    }

    public void clearObservers() {
        if (this.masterReader != null) {
            this.masterReader.clearObservers();
        } else {
            this.reader.clearObservers();
        }
    }

    public int countObservers() {
        if (this.masterReader != null) {
            return this.masterReader.countObservers();
        }
        return this.reader.countObservers();
    }

    public void startCardDetection(ObservableReader.PollingMode pollingMode) {
        this.reader.startCardDetection(pollingMode);
    }

    public void stopCardDetection() {
        this.reader.stopCardDetection();
    }

    public void setDefaultSelectionRequest(AbstractDefaultSelectionsRequest defaultSelectionsRequest, ObservableReader.NotificationMode notificationMode) {
        this.reader.setDefaultSelectionRequest(defaultSelectionsRequest, notificationMode);
    }

    public void setDefaultSelectionRequest(AbstractDefaultSelectionsRequest defaultSelectionsRequest, ObservableReader.NotificationMode notificationMode, ObservableReader.PollingMode pollingMode) {
        this.reader.setDefaultSelectionRequest(defaultSelectionsRequest, notificationMode, pollingMode);
    }

    public void finalizeCardProcessing() {
        this.reader.finalizeCardProcessing();
    }

    @Override
    public boolean isContactless() {
        return this.reader.isContactless();
    }

    ObservableRemoteReaderServerImpl getMasterReader() {
        return this.masterReader;
    }
}

