/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.plugin.ObservableReaderNotifier;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsRequest;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.impl.AbstractNode;
import org.eclipse.keyple.distributed.impl.AbstractRemoteReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObservableRemoteReaderImpl
extends AbstractRemoteReader
implements ObservableReaderNotifier {
    private static final Logger logger = LoggerFactory.getLogger(ObservableRemoteReaderImpl.class);
    private final List<ObservableReader.ReaderObserver> observers = new ArrayList<ObservableReader.ReaderObserver>();
    private final ExecutorService eventNotificationPool;

    ObservableRemoteReaderImpl(String pluginName, String localReaderName, AbstractNode node, String sessionId, String clientNodeId, ExecutorService eventNotificationPool) {
        super(pluginName, localReaderName, node, sessionId, clientNodeId);
        this.eventNotificationPool = eventNotificationPool;
    }

    public void notifyObservers(final ReaderEvent event) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Notifying a reader event to {} observers. EVENTNAME = {}", new Object[]{this.getName(), this.countObservers(), event.getEventType().name()});
        }
        ArrayList<ObservableReader.ReaderObserver> observersCopy = new ArrayList<ObservableReader.ReaderObserver>(this.observers);
        for (final ObservableReader.ReaderObserver observer : observersCopy) {
            this.eventNotificationPool.execute(new Runnable(){

                @Override
                public void run() {
                    observer.update(event);
                }
            });
        }
    }

    public void addObserver(ObservableReader.ReaderObserver observer) {
        Assert.getInstance().notNull((Object)observer, "Reader Observer");
        if (this.observers.add(observer) && logger.isTraceEnabled()) {
            logger.trace("[{}] Added reader observer '{}'", (Object)this.getName(), (Object)observer.getClass().getSimpleName());
        }
    }

    public void removeObserver(ObservableReader.ReaderObserver observer) {
        Assert.getInstance().notNull((Object)observer, "Reader Observer");
        if (this.observers.remove(observer) && logger.isTraceEnabled()) {
            logger.trace("[{}] Deleted reader observer '{}'", (Object)this.getName(), (Object)observer.getClass().getSimpleName());
        }
    }

    public void clearObservers() {
        this.observers.clear();
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Clear reader observers", (Object)this.getName());
        }
    }

    public int countObservers() {
        return this.observers.size();
    }

    public void startCardDetection(ObservableReader.PollingMode pollingMode) {
        Assert.getInstance().notNull((Object)pollingMode, "Polling Mode");
        JsonObject body = new JsonObject();
        body.addProperty("pollingMode", pollingMode.name());
        this.sendRequest(MessageDto.Action.START_CARD_DETECTION, body);
    }

    public void stopCardDetection() {
        this.sendRequest(MessageDto.Action.STOP_CARD_DETECTION, null);
    }

    public void setDefaultSelectionRequest(AbstractDefaultSelectionsRequest defaultSelectionsRequest, ObservableReader.NotificationMode notificationMode) {
        this.setDefaultSelectionRequest(defaultSelectionsRequest, notificationMode, null);
    }

    public void setDefaultSelectionRequest(AbstractDefaultSelectionsRequest defaultSelectionsRequest, ObservableReader.NotificationMode notificationMode, ObservableReader.PollingMode pollingMode) {
        Assert.getInstance().notNull((Object)defaultSelectionsRequest, "Default Selections Request").notNull((Object)notificationMode, "Notification Mode");
        JsonObject body = new JsonObject();
        body.add("defaultSelectionsRequest", KeypleGsonParser.getParser().toJsonTree((Object)defaultSelectionsRequest));
        body.addProperty("notificationMode", notificationMode.name());
        if (pollingMode != null) {
            body.addProperty("pollingMode", pollingMode.name());
        }
        this.sendRequest(MessageDto.Action.SET_DEFAULT_SELECTION, body);
    }

    public void finalizeCardProcessing() {
        this.sendRequest(MessageDto.Action.FINALIZE_CARD_PROCESSING, null);
    }
}

