/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import java.util.List;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.RemoteReaderServer;
import org.eclipse.keyple.distributed.impl.AbstractRemoteReader;

abstract class AbstractRemoteReaderServer
implements RemoteReaderServer,
ProxyReader {
    private final AbstractRemoteReader reader;
    private final String serviceId;
    private final String initialCardContentJson;
    private final String userInputDataJson;

    AbstractRemoteReaderServer(AbstractRemoteReader reader, String serviceId, String userInputDataJson, String initialCardContentJson) {
        this.reader = reader;
        this.serviceId = serviceId;
        this.userInputDataJson = userInputDataJson;
        this.initialCardContentJson = initialCardContentJson;
    }

    public List<CardSelectionResponse> transmitCardSelectionRequests(List<CardSelectionRequest> cardSelectionRequests, MultiSelectionProcessing multiSelectionProcessing, ChannelControl channelControl) {
        return this.reader.transmitCardSelectionRequests(cardSelectionRequests, multiSelectionProcessing, channelControl);
    }

    public CardResponse transmitCardRequest(CardRequest cardRequest, ChannelControl channelControl) {
        return this.reader.transmitCardRequest(cardRequest, channelControl);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public <T> T getUserInputData(Class<T> classOfT) {
        Assert.getInstance().notNull(classOfT, "classOfT");
        return (T)(this.userInputDataJson != null ? KeypleGsonParser.getParser().fromJson(this.userInputDataJson, classOfT) : null);
    }

    @Override
    public <T extends AbstractSmartCard> T getInitialCardContent(Class<T> classOfT) {
        Assert.getInstance().notNull(classOfT, "classOfT");
        return (T)(this.initialCardContentJson != null ? (AbstractSmartCard)KeypleGsonParser.getParser().fromJson(this.initialCardContentJson, classOfT) : null);
    }

    public boolean isCardPresent() {
        return this.reader.isCardPresent();
    }

    public String getName() {
        return this.reader.getName();
    }

    String getSessionId() {
        return this.reader.getSessionId();
    }

    String getClientNodeId() {
        return this.reader.getClientNodeId();
    }

    public void releaseChannel() {
        this.reader.releaseChannel();
    }

    public void activateProtocol(String readerProtocolName, String applicationProtocolName) {
        throw new UnsupportedOperationException("activateProtocol method is not implemented in plugin remote, use it only locally");
    }

    public void deactivateProtocol(String readerProtocolName) {
        throw new UnsupportedOperationException("deactivateProtocol method is not implemented in plugin remote, use it only locally");
    }

    public boolean isContactless() {
        return this.reader.isContactless();
    }
}

