/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.impl.AbstractNode;

abstract class AbstractRemoteReader
extends AbstractReader {
    private final AbstractNode node;
    private final String clientNodeId;
    private final String localReaderName;
    private final String sessionId;

    AbstractRemoteReader(String pluginName, String localReaderName, AbstractNode node, String sessionId, String clientNodeId) {
        super(pluginName, UUID.randomUUID().toString());
        this.localReaderName = localReaderName;
        this.node = node;
        this.sessionId = sessionId;
        this.clientNodeId = clientNodeId;
    }

    protected List<CardSelectionResponse> processCardSelectionRequests(List<CardSelectionRequest> cardSelectionRequests, MultiSelectionProcessing multiSelectionProcessing, ChannelControl channelControl) {
        JsonObject body = new JsonObject();
        body.addProperty("cardSelectionRequests", KeypleGsonParser.getParser().toJson(cardSelectionRequests, new TypeToken<ArrayList<CardSelectionRequest>>(){}.getType()));
        body.addProperty("multiSelectionProcessing", multiSelectionProcessing.name());
        body.addProperty("channelControl", channelControl.name());
        MessageDto response = this.sendRequest(MessageDto.Action.TRANSMIT_CARD_SELECTION, body);
        return (List)KeypleGsonParser.getParser().fromJson(response.getBody(), new TypeToken<ArrayList<CardSelectionResponse>>(){}.getType());
    }

    protected CardResponse processCardRequest(CardRequest cardRequest, ChannelControl channelControl) {
        JsonObject body = new JsonObject();
        body.addProperty("cardRequest", KeypleGsonParser.getParser().toJson((Object)cardRequest, CardRequest.class));
        body.addProperty("channelControl", channelControl.name());
        MessageDto response = this.sendRequest(MessageDto.Action.TRANSMIT, body);
        return (CardResponse)KeypleGsonParser.getParser().fromJson(response.getBody(), CardResponse.class);
    }

    public boolean isCardPresent() {
        MessageDto response = this.sendRequest(MessageDto.Action.IS_CARD_PRESENT, null);
        return (Boolean)KeypleGsonParser.getParser().fromJson(response.getBody(), Boolean.class);
    }

    public void releaseChannel() {
        this.sendRequest(MessageDto.Action.RELEASE_CHANNEL, null);
    }

    public void activateProtocol(String readerProtocolName, String applicationProtocolName) {
        throw new UnsupportedOperationException("activateProtocol method is not implemented in plugin remote, use it only locally");
    }

    public void deactivateProtocol(String readerProtocolName) {
        throw new UnsupportedOperationException("activateProtocol method is not implemented in plugin remote, use it only locally");
    }

    public boolean isContactless() {
        MessageDto response = this.sendRequest(MessageDto.Action.IS_READER_CONTACTLESS, null);
        return (Boolean)KeypleGsonParser.getParser().fromJson(response.getBody(), Boolean.class);
    }

    MessageDto sendRequest(MessageDto.Action action, JsonObject body) {
        MessageDto message = new MessageDto().setSessionId(this.sessionId != null ? this.sessionId : UUID.randomUUID().toString()).setAction(action.name()).setRemoteReaderName(this.getName()).setLocalReaderName(this.localReaderName).setClientNodeId(this.clientNodeId).setBody(body != null ? body.toString() : null);
        MessageDto response = this.node.sendRequest(message);
        this.checkError(response);
        return response;
    }

    private void checkError(MessageDto message) {
        if (message.getAction().equals(MessageDto.Action.ERROR.name())) {
            BodyError body = (BodyError)KeypleGsonParser.getParser().fromJson(message.getBody(), BodyError.class);
            throw body.getException();
        }
    }

    String getSessionId() {
        return this.sessionId;
    }

    String getClientNodeId() {
        return this.clientNodeId;
    }

    String getLocalReaderName() {
        return this.localReaderName;
    }
}

