/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.SyncNodeServer;
import org.eclipse.keyple.distributed.impl.AbstractMessageHandler;
import org.eclipse.keyple.distributed.impl.AbstractNode;
import org.eclipse.keyple.distributed.impl.ServerPushEventStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncNodeServerImpl
extends AbstractNode
implements SyncNodeServer {
    private static final Logger logger = LoggerFactory.getLogger(SyncNodeServerImpl.class);
    private final Map<String, SessionManager> sessionManagers;
    private final Map<String, ServerPushEventManager> pluginManagers;
    private final Map<String, ServerPushEventManager> readerManagers;
    private final JsonParser jsonParser = new JsonParser();

    SyncNodeServerImpl(AbstractMessageHandler handler, int timeoutInSecond) {
        super(handler, timeoutInSecond);
        this.sessionManagers = new ConcurrentHashMap<String, SessionManager>();
        this.pluginManagers = new ConcurrentHashMap<String, ServerPushEventManager>();
        this.readerManagers = new ConcurrentHashMap<String, ServerPushEventManager>();
    }

    @Override
    void openSession(String sessionId) {
        throw new UnsupportedOperationException("openSession");
    }

    @Override
    public List<MessageDto> onRequest(MessageDto msg) {
        ArrayList responses;
        Assert.getInstance().notNull((Object)msg, "msg").notEmpty(msg.getSessionId(), "sessionId").notEmpty(msg.getAction(), "action").notEmpty(msg.getClientNodeId(), "clientNodeId");
        MessageDto.Action action = MessageDto.Action.valueOf(msg.getAction());
        switch (action) {
            case CHECK_PLUGIN_EVENT: {
                responses = this.checkEvents(msg, this.pluginManagers);
                break;
            }
            case CHECK_READER_EVENT: {
                responses = this.checkEvents(msg, this.readerManagers);
                break;
            }
            default: {
                responses = this.processOnRequest(msg);
            }
        }
        return responses != null ? responses : new ArrayList(0);
    }

    private List<MessageDto> checkEvents(MessageDto msg, Map<String, ServerPushEventManager> eventManagers) {
        ServerPushEventManager manager = this.getEventManager(msg, eventManagers);
        return manager.checkEvents(msg);
    }

    private List<MessageDto> processOnRequest(MessageDto msg) {
        MessageDto response;
        SessionManager manager = this.sessionManagers.get(msg.getSessionId());
        if (manager == null) {
            manager = new SessionManager(msg.getSessionId());
            this.sessionManagers.put(msg.getSessionId(), manager);
        }
        return (response = manager.onRequest(msg)) != null ? Collections.singletonList(response) : null;
    }

    @Override
    MessageDto sendRequest(MessageDto msg) {
        msg.setServerNodeId(this.nodeId);
        SessionManager manager = this.sessionManagers.get(msg.getSessionId());
        try {
            return manager.sendRequest(msg);
        }
        catch (RuntimeException e) {
            this.sessionManagers.remove(msg.getSessionId());
            throw e;
        }
    }

    @Override
    void sendMessage(MessageDto msg) {
        msg.setServerNodeId(this.nodeId);
        MessageDto.Action action = MessageDto.Action.valueOf(msg.getAction());
        switch (action) {
            case PLUGIN_EVENT: {
                this.postEvent(msg, this.pluginManagers);
                break;
            }
            case READER_EVENT: {
                this.postEvent(msg, this.readerManagers);
                break;
            }
            default: {
                this.processSendMessage(msg);
            }
        }
    }

    @Override
    void closeSession(String sessionId) {
        throw new UnsupportedOperationException("closeSession");
    }

    private void postEvent(MessageDto msg, Map<String, ServerPushEventManager> eventManagers) {
        ServerPushEventManager manager = this.getEventManager(msg, eventManagers);
        manager.postEvent(msg);
    }

    private ServerPushEventManager getEventManager(MessageDto msg, Map<String, ServerPushEventManager> eventManagers) {
        ServerPushEventManager manager = eventManagers.get(msg.getClientNodeId());
        if (manager == null) {
            manager = new ServerPushEventManager(msg.getClientNodeId());
            eventManagers.put(msg.getClientNodeId(), manager);
        }
        return manager;
    }

    private void processSendMessage(MessageDto msg) {
        SessionManager manager = this.sessionManagers.get(msg.getSessionId());
        if (manager == null) {
            throw new IllegalStateException("Session is closed");
        }
        try {
            manager.sendMessage(msg);
        }
        finally {
            this.sessionManagers.remove(msg.getSessionId());
        }
    }

    private class ServerPushEventManager {
        private final String clientNodeId;
        private List<MessageDto> events;
        private ServerPushEventStrategy strategy;

        private ServerPushEventManager(String clientNodeId) {
            this.clientNodeId = clientNodeId;
            this.events = null;
            this.strategy = null;
        }

        private synchronized void postEvent(MessageDto msg) {
            if (this.events == null) {
                this.events = new ArrayList<MessageDto>(1);
            }
            this.events.add(msg);
            if (this.strategy != null && this.strategy.getType() == ServerPushEventStrategy.Type.LONG_POLLING) {
                this.notifyAll();
            }
        }

        private synchronized List<MessageDto> checkEvents(MessageDto msg) {
            try {
                if (this.events != null) {
                    List<MessageDto> list = this.events;
                    return list;
                }
                this.registerClientStrategy(msg);
                if (this.strategy.getType() == ServerPushEventStrategy.Type.LONG_POLLING) {
                    this.waitAtMost(this.strategy.getDuration());
                }
                List<MessageDto> list = this.events;
                return list;
            }
            finally {
                this.events = null;
            }
        }

        private void registerClientStrategy(MessageDto msg) {
            if (this.strategy == null) {
                ServerPushEventStrategy.Type type;
                JsonObject body;
                try {
                    body = SyncNodeServerImpl.this.jsonParser.parse(msg.getBody()).getAsJsonObject();
                    type = ServerPushEventStrategy.Type.valueOf(body.get("strategy").getAsString());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("body", e);
                }
                this.strategy = new ServerPushEventStrategy(type);
                if (type == ServerPushEventStrategy.Type.LONG_POLLING) {
                    try {
                        int maxWaitingTime = body.get("duration").getAsInt() * 1000;
                        this.strategy.setDuration(maxWaitingTime);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("long polling duration", e);
                    }
                }
            }
        }

        private synchronized void waitAtMost(int maxAwaitingTime) {
            try {
                long deadline = new Date().getTime() + (long)maxAwaitingTime;
                while (this.events == null && new Date().getTime() < deadline) {
                    this.wait(maxAwaitingTime);
                }
            }
            catch (InterruptedException e) {
                logger.error("Unexpected interruption of the task associated with the node's id {}", (Object)this.clientNodeId, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private class SessionManager
    extends AbstractNode.AbstractSessionManager {
        private SessionManager(String sessionId) {
            super(sessionId);
        }

        @Override
        void checkIfExternalErrorOccurred() {
        }

        private synchronized MessageDto onRequest(MessageDto msg) {
            this.checkState(AbstractNode.SessionManagerState.INITIALIZED, AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN);
            if (this.state == AbstractNode.SessionManagerState.INITIALIZED) {
                this.state = AbstractNode.SessionManagerState.ON_REQUEST;
                SyncNodeServerImpl.this.handler.onMessage(msg);
            } else {
                this.postMessageAndNotify(msg, AbstractNode.SessionManagerState.SEND_REQUEST_END);
            }
            this.waitForState(AbstractNode.SessionManagerState.SEND_MESSAGE, AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN);
            return this.response;
        }

        private synchronized MessageDto sendRequest(MessageDto msg) {
            this.postMessageAndNotify(msg, AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN);
            this.waitForState(AbstractNode.SessionManagerState.SEND_REQUEST_END);
            return this.response;
        }

        private synchronized void sendMessage(MessageDto msg) {
            this.postMessageAndNotify(msg, AbstractNode.SessionManagerState.SEND_MESSAGE);
        }

        private synchronized void postMessageAndNotify(MessageDto msg, AbstractNode.SessionManagerState targetState) {
            this.response = msg;
            this.state = targetState;
            this.notifyAll();
        }
    }
}

