/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.SyncNodeClient;
import org.eclipse.keyple.distributed.impl.AbstractMessageHandler;
import org.eclipse.keyple.distributed.impl.AbstractNode;
import org.eclipse.keyple.distributed.impl.ServerPushEventStrategy;
import org.eclipse.keyple.distributed.spi.SyncEndpointClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncNodeClientImpl
extends AbstractNode
implements SyncNodeClient {
    private static final Logger logger = LoggerFactory.getLogger(SyncNodeClientImpl.class);
    private final SyncEndpointClient endpoint;

    SyncNodeClientImpl(AbstractMessageHandler handler, SyncEndpointClient endpoint, ServerPushEventStrategy pluginObservationStrategy, ServerPushEventStrategy readerObservationStrategy) {
        super(handler, 0);
        this.endpoint = endpoint;
        if (pluginObservationStrategy != null) {
            EventObserver pluginEventObserver = new EventObserver(pluginObservationStrategy, MessageDto.Action.CHECK_PLUGIN_EVENT);
            pluginEventObserver.start();
        }
        if (readerObservationStrategy != null) {
            EventObserver readerEventObserver = new EventObserver(readerObservationStrategy, MessageDto.Action.CHECK_READER_EVENT);
            readerEventObserver.start();
        }
    }

    @Override
    void openSession(String sessionId) {
    }

    @Override
    MessageDto sendRequest(MessageDto msg) {
        msg.setClientNodeId(this.nodeId);
        List<MessageDto> responses = this.endpoint.sendRequest(msg);
        if (responses == null || responses.isEmpty()) {
            return null;
        }
        if (responses.size() == 1) {
            MessageDto response = responses.get(0);
            Assert.getInstance().notNull((Object)response, "msg").notEmpty(response.getSessionId(), "sessionId").notEmpty(response.getAction(), "action").notEmpty(response.getClientNodeId(), "clientNodeId").notEmpty(response.getServerNodeId(), "serverNodeId");
            return response;
        }
        throw new IllegalStateException("The list returned by the client endpoint should have contained a single element but contains " + responses.size() + " elements.");
    }

    @Override
    void sendMessage(MessageDto msg) {
        msg.setClientNodeId(this.nodeId);
        this.endpoint.sendRequest(msg);
    }

    @Override
    void closeSession(String sessionId) {
    }

    private class EventObserver {
        private final ServerPushEventStrategy strategy;
        private final MessageDto.Action action;
        private final MessageDto msg;
        private final Thread thread;

        private EventObserver(ServerPushEventStrategy strategy, MessageDto.Action action) {
            this.strategy = strategy;
            this.action = action;
            this.msg = this.buildMessage();
            this.thread = strategy.getType() == ServerPushEventStrategy.Type.POLLING ? new PollingEventObserver() : new LongPollingEventObserver();
            this.thread.setUncaughtExceptionHandler(new EventObserverUncaughtExceptionHandler());
            this.thread.setName(action.name());
        }

        private MessageDto buildMessage() {
            JsonObject body = new JsonObject();
            body.addProperty("strategy", this.strategy.getType().name());
            if (this.strategy.getType() == ServerPushEventStrategy.Type.LONG_POLLING) {
                body.addProperty("duration", (Number)this.strategy.getDuration());
            }
            return new MessageDto().setSessionId(UUID.randomUUID().toString()).setAction(this.action.name()).setClientNodeId(SyncNodeClientImpl.this.nodeId).setBody(body.toString());
        }

        private void checkForEvents() {
            List<MessageDto> responses;
            try {
                responses = SyncNodeClientImpl.this.endpoint.sendRequest(this.msg);
            }
            catch (Exception e) {
                logger.error("Server connection error", (Throwable)e);
                responses = this.retryRequest();
            }
            if (responses != null && !responses.isEmpty()) {
                for (MessageDto event : responses) {
                    SyncNodeClientImpl.this.handler.onMessage(event);
                }
            }
        }

        private List<MessageDto> retryRequest() {
            int timer1 = 0;
            int timer2 = 1000;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    int timer = timer1 + timer2;
                    Thread.sleep(timer);
                    logger.info("Retry to send request after {} seconds...", (Object)(timer / 1000));
                    List<MessageDto> responses = this.sendRequestSilently();
                    if (responses != null) {
                        logger.info("Server connection retrieved");
                        return responses;
                    }
                    timer1 = timer2;
                    timer2 = timer;
                }
                catch (InterruptedException e) {
                    logger.error("Unexpected interruption of thread {}", (Object)Thread.currentThread().getName(), (Object)e);
                    Thread.currentThread().interrupt();
                }
            }
            return new ArrayList<MessageDto>();
        }

        private List<MessageDto> sendRequestSilently() {
            try {
                return SyncNodeClientImpl.this.endpoint.sendRequest(this.msg);
            }
            catch (Exception e) {
                return null;
            }
        }

        private void start() {
            this.thread.start();
        }

        private class EventObserverUncaughtExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private EventObserverUncaughtExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Interruption of thread {} caused by an unhandled exception", (Object)t.getName(), (Object)e);
            }
        }

        private class LongPollingEventObserver
        extends Thread {
            private LongPollingEventObserver() {
            }

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    EventObserver.this.checkForEvents();
                }
            }
        }

        private class PollingEventObserver
        extends Thread {
            private PollingEventObserver() {
            }

            @Override
            public void run() {
                int requestFrequencyInMillis = EventObserver.this.strategy.getDuration() * 1000;
                while (!Thread.currentThread().isInterrupted()) {
                    EventObserver.this.checkForEvents();
                    try {
                        Thread.sleep(requestFrequencyInMillis);
                    }
                    catch (InterruptedException e) {
                        logger.error("Unexpected interruption of thread {}", (Object)this.getName(), (Object)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

