/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AsyncNodeServer;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.NodeCommunicationException;
import org.eclipse.keyple.distributed.impl.AbstractMessageHandler;
import org.eclipse.keyple.distributed.impl.AbstractNode;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServer;

final class AsyncNodeServerImpl
extends AbstractNode
implements AsyncNodeServer {
    private static final String SESSION_ID = "sessionId";
    private final AsyncEndpointServer endpoint;
    private final Map<String, SessionManager> sessionManagers;

    AsyncNodeServerImpl(AbstractMessageHandler handler, AsyncEndpointServer endpoint, int timeoutInSecond) {
        super(handler, timeoutInSecond);
        this.endpoint = endpoint;
        this.sessionManagers = new ConcurrentHashMap<String, SessionManager>();
    }

    @Override
    void openSession(String sessionId) {
        throw new UnsupportedOperationException("openSession");
    }

    @Override
    MessageDto sendRequest(MessageDto msg) {
        msg.setServerNodeId(this.nodeId);
        SessionManager manager = this.getManagerForHandler(msg.getSessionId());
        return manager.sendRequest(msg);
    }

    @Override
    void sendMessage(MessageDto msg) {
        msg.setServerNodeId(this.nodeId);
        SessionManager manager = this.getManagerForHandler(msg.getSessionId());
        manager.sendMessage(msg);
    }

    @Override
    void closeSession(String sessionId) {
        throw new UnsupportedOperationException("closeSession");
    }

    private SessionManager getManagerForHandler(String sessionId) {
        SessionManager manager = this.sessionManagers.get(sessionId);
        if (manager == null) {
            throw new IllegalStateException("The node's session [" + sessionId + "] is closed.");
        }
        return manager;
    }

    @Override
    public void onMessage(MessageDto msg) {
        Assert.getInstance().notNull((Object)msg, "msg").notEmpty(msg.getSessionId(), SESSION_ID).notEmpty(msg.getAction(), "action").notEmpty(msg.getClientNodeId(), "clientNodeId");
        SessionManager manager = this.sessionManagers.get(msg.getSessionId());
        if (manager == null) {
            manager = new SessionManager(msg.getSessionId());
            this.sessionManagers.put(msg.getSessionId(), manager);
        }
        manager.onMessage(msg);
    }

    @Override
    public void onError(String sessionId, Throwable error) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID).notNull((Object)error, "error");
        SessionManager manager = this.sessionManagers.get(sessionId);
        Assert.getInstance().notNull((Object)manager, SESSION_ID);
        manager.onError(error);
    }

    @Override
    public void onClose(String sessionId) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID);
        SessionManager manager = this.sessionManagers.remove(sessionId);
        Assert.getInstance().notNull((Object)manager, SESSION_ID);
    }

    private class SessionManager
    extends AbstractNode.AbstractSessionManager {
        private SessionManager(String sessionId) {
            super(sessionId);
        }

        @Override
        void checkIfExternalErrorOccurred() {
            if (this.state == AbstractNode.SessionManagerState.EXTERNAL_ERROR_OCCURRED) {
                this.state = AbstractNode.SessionManagerState.ABORTED_SESSION;
                throw new NodeCommunicationException(this.error.getMessage(), this.error);
            }
        }

        private synchronized void onMessage(MessageDto msg) {
            this.checkState(AbstractNode.SessionManagerState.INITIALIZED, AbstractNode.SessionManagerState.ON_MESSAGE, AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN, AbstractNode.SessionManagerState.SEND_REQUEST_END, AbstractNode.SessionManagerState.SEND_MESSAGE);
            if (this.state == AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN) {
                this.response = msg;
                this.state = AbstractNode.SessionManagerState.SEND_REQUEST_END;
                this.notifyAll();
            } else {
                this.state = AbstractNode.SessionManagerState.ON_MESSAGE;
                AsyncNodeServerImpl.this.handler.onMessage(msg);
            }
        }

        private synchronized MessageDto sendRequest(MessageDto msg) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN;
            this.response = null;
            AsyncNodeServerImpl.this.endpoint.sendMessage(msg);
            this.waitForState(AbstractNode.SessionManagerState.SEND_REQUEST_END);
            return this.response;
        }

        private synchronized void sendMessage(MessageDto msg) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNode.SessionManagerState.SEND_MESSAGE;
            AsyncNodeServerImpl.this.endpoint.sendMessage(msg);
            this.checkIfExternalErrorOccurred();
        }

        private synchronized void onError(Throwable e) {
            this.checkState(AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN, AbstractNode.SessionManagerState.SEND_MESSAGE);
            this.error = e;
            this.state = AbstractNode.SessionManagerState.EXTERNAL_ERROR_OCCURRED;
            this.notifyAll();
        }
    }
}

