/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AsyncNodeClient;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.NodeCommunicationException;
import org.eclipse.keyple.distributed.impl.AbstractMessageHandler;
import org.eclipse.keyple.distributed.impl.AbstractNode;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncNodeClientImpl
extends AbstractNode
implements AsyncNodeClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncNodeClientImpl.class);
    private static final String SESSION_ID = "sessionId";
    private final AsyncEndpointClient endpoint;
    private final Map<String, SessionManager> sessionManagers;

    AsyncNodeClientImpl(AbstractMessageHandler handler, AsyncEndpointClient endpoint, int timeoutInSecond) {
        super(handler, timeoutInSecond);
        this.endpoint = endpoint;
        this.sessionManagers = new ConcurrentHashMap<String, SessionManager>();
    }

    @Override
    void openSession(String sessionId) {
        SessionManager manager = new SessionManager(sessionId);
        this.sessionManagers.put(sessionId, manager);
        manager.openSession();
    }

    @Override
    public void onOpen(String sessionId) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID);
        SessionManager manager = this.getManagerForEndpoint(sessionId);
        if (manager != null) {
            manager.onOpen();
        }
    }

    @Override
    MessageDto sendRequest(MessageDto msg) {
        msg.setClientNodeId(this.nodeId);
        SessionManager manager = this.sessionManagers.get(msg.getSessionId());
        return manager.sendRequest(msg);
    }

    @Override
    void sendMessage(MessageDto msg) {
        msg.setClientNodeId(this.nodeId);
        SessionManager manager = this.sessionManagers.get(msg.getSessionId());
        manager.sendMessage(msg);
    }

    @Override
    public void onMessage(MessageDto msg) {
        Assert.getInstance().notNull((Object)msg, "msg").notEmpty(msg.getSessionId(), SESSION_ID).notEmpty(msg.getAction(), "action").notEmpty(msg.getClientNodeId(), "clientNodeId").notEmpty(msg.getServerNodeId(), "serverNodeId");
        SessionManager manager = this.getManagerForEndpoint(msg.getSessionId());
        if (manager != null) {
            MessageDto.Action action = MessageDto.Action.valueOf(msg.getAction());
            switch (action) {
                case PLUGIN_EVENT: 
                case READER_EVENT: {
                    manager.onEvent(msg);
                    break;
                }
                default: {
                    manager.onResponse(msg);
                }
            }
        }
    }

    @Override
    void closeSession(String sessionId) {
        SessionManager manager = this.sessionManagers.get(sessionId);
        try {
            manager.closeSession();
        }
        finally {
            this.sessionManagers.remove(sessionId);
        }
    }

    @Override
    public void onClose(String sessionId) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID);
        SessionManager manager = this.getManagerForEndpoint(sessionId);
        if (manager != null) {
            manager.onClose();
        }
    }

    @Override
    public void onError(String sessionId, Throwable error) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID).notNull((Object)error, "error");
        SessionManager manager = this.getManagerForEndpoint(sessionId);
        if (manager != null) {
            manager.onError(error);
        }
    }

    private SessionManager getManagerForEndpoint(String sessionId) {
        SessionManager manager = this.sessionManagers.get(sessionId);
        if (manager == null) {
            logger.warn("The node's session [{}] is not found. It was maybe closed due to a timeout.", (Object)sessionId);
        }
        return manager;
    }

    private class SessionManager
    extends AbstractNode.AbstractSessionManager {
        private SessionManager(String sessionId) {
            super(sessionId);
        }

        @Override
        void checkIfExternalErrorOccurred() {
            if (this.state == AbstractNode.SessionManagerState.EXTERNAL_ERROR_OCCURRED) {
                this.state = AbstractNode.SessionManagerState.ABORTED_SESSION;
                throw new NodeCommunicationException(this.error.getMessage(), this.error);
            }
        }

        private synchronized void openSession() {
            this.state = AbstractNode.SessionManagerState.OPEN_SESSION_BEGIN;
            AsyncNodeClientImpl.this.endpoint.openSession(this.sessionId);
            this.waitForState(AbstractNode.SessionManagerState.OPEN_SESSION_END);
        }

        private synchronized void onOpen() {
            this.checkState(AbstractNode.SessionManagerState.OPEN_SESSION_BEGIN);
            this.state = AbstractNode.SessionManagerState.OPEN_SESSION_END;
            this.notifyAll();
        }

        private synchronized MessageDto sendRequest(MessageDto msg) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN;
            this.response = null;
            AsyncNodeClientImpl.this.endpoint.sendMessage(msg);
            this.waitForState(AbstractNode.SessionManagerState.SEND_REQUEST_END);
            return this.response;
        }

        private synchronized void onResponse(MessageDto msg) {
            this.checkState(AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN);
            this.response = msg;
            this.state = AbstractNode.SessionManagerState.SEND_REQUEST_END;
            this.notifyAll();
        }

        private void onEvent(MessageDto msg) {
            AsyncNodeClientImpl.this.handler.onMessage(msg);
        }

        private synchronized void sendMessage(MessageDto msg) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNode.SessionManagerState.SEND_MESSAGE;
            AsyncNodeClientImpl.this.endpoint.sendMessage(msg);
            this.checkIfExternalErrorOccurred();
        }

        private synchronized void closeSession() {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNode.SessionManagerState.CLOSE_SESSION_BEGIN;
            AsyncNodeClientImpl.this.endpoint.closeSession(this.sessionId);
            this.waitForState(AbstractNode.SessionManagerState.CLOSE_SESSION_END);
        }

        private synchronized void onClose() {
            this.checkState(AbstractNode.SessionManagerState.CLOSE_SESSION_BEGIN);
            this.state = AbstractNode.SessionManagerState.CLOSE_SESSION_END;
            this.notifyAll();
        }

        private synchronized void onError(Throwable e) {
            this.checkState(AbstractNode.SessionManagerState.OPEN_SESSION_BEGIN, AbstractNode.SessionManagerState.SEND_REQUEST_BEGIN, AbstractNode.SessionManagerState.SEND_MESSAGE, AbstractNode.SessionManagerState.CLOSE_SESSION_BEGIN);
            this.error = e;
            this.state = AbstractNode.SessionManagerState.EXTERNAL_ERROR_OCCURRED;
            this.notifyAll();
        }
    }
}

