/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.NodeCommunicationException;
import org.eclipse.keyple.distributed.impl.AbstractMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNode {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNode.class);
    final String nodeId = UUID.randomUUID().toString();
    final AbstractMessageHandler handler;
    private final int timeout;

    AbstractNode(AbstractMessageHandler handler, int timeoutInSecond) {
        this.handler = handler;
        this.timeout = timeoutInSecond * 1000;
    }

    abstract void openSession(String var1);

    abstract MessageDto sendRequest(MessageDto var1);

    abstract void sendMessage(MessageDto var1);

    abstract void closeSession(String var1);

    void closeSessionSilently(String sessionId) {
        try {
            this.closeSession(sessionId);
        }
        catch (RuntimeException e) {
            logger.error("Error during the silent closing of node's session [{}] : {}", new Object[]{sessionId, e.getMessage(), e});
        }
    }

    abstract class AbstractSessionManager {
        final String sessionId;
        volatile SessionManagerState state;
        MessageDto response;
        Throwable error;

        AbstractSessionManager(String sessionId) {
            this.sessionId = sessionId;
            this.state = SessionManagerState.INITIALIZED;
            this.response = null;
            this.error = null;
        }

        synchronized void waitForState(SessionManagerState ... targetStates) {
            for (SessionManagerState targetState : targetStates) {
                if (this.state != targetState) continue;
                return;
            }
            this.checkIfExternalErrorOccurred();
            try {
                long deadline = new Date().getTime() + (long)AbstractNode.this.timeout;
                while (new Date().getTime() < deadline) {
                    this.wait(AbstractNode.this.timeout);
                    for (SessionManagerState targetState : targetStates) {
                        if (this.state != targetState) continue;
                        return;
                    }
                    this.checkIfExternalErrorOccurred();
                }
                this.timeoutOccurred();
            }
            catch (InterruptedException e) {
                logger.error("Unexpected interruption of the task associated with the node's session {}", (Object)this.sessionId, (Object)e);
                Thread.currentThread().interrupt();
            }
        }

        abstract void checkIfExternalErrorOccurred();

        void checkState(SessionManagerState ... targetStates) {
            for (SessionManagerState targetState : targetStates) {
                if (this.state != targetState) continue;
                return;
            }
            throw new IllegalStateException("The status of the node's session manager [" + this.sessionId + "] should have been one of " + Arrays.toString((Object[])targetStates) + ", but is currently " + (Object)((Object)this.state));
        }

        void timeoutOccurred() {
            this.state = SessionManagerState.ABORTED_SESSION;
            logger.error("Timeout occurs for the task associated with the node's session [{}]", (Object)this.sessionId);
            throw new NodeCommunicationException("Timeout occurs for the task associated with the node's session [" + this.sessionId + "]");
        }
    }

    static enum SessionManagerState {
        INITIALIZED,
        OPEN_SESSION_BEGIN,
        OPEN_SESSION_END,
        ON_REQUEST,
        ON_MESSAGE,
        SEND_REQUEST_BEGIN,
        SEND_REQUEST_END,
        SEND_MESSAGE,
        EXTERNAL_ERROR_OCCURRED,
        CLOSE_SESSION_BEGIN,
        CLOSE_SESSION_END,
        ABORTED_SESSION;

    }
}

