/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import java.util.UUID;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.impl.AbstractNode;
import org.eclipse.keyple.distributed.impl.AsyncNodeClientImpl;
import org.eclipse.keyple.distributed.impl.AsyncNodeServerImpl;
import org.eclipse.keyple.distributed.impl.ServerPushEventStrategy;
import org.eclipse.keyple.distributed.impl.SyncNodeClientImpl;
import org.eclipse.keyple.distributed.impl.SyncNodeServerImpl;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClient;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServer;
import org.eclipse.keyple.distributed.spi.SyncEndpointClient;

abstract class AbstractMessageHandler {
    AbstractNode node;

    AbstractMessageHandler() {
    }

    abstract void onMessage(MessageDto var1);

    void bindAsyncNodeClient(AsyncEndpointClient endpoint, int timeoutInSecond) {
        this.node = new AsyncNodeClientImpl(this, endpoint, timeoutInSecond);
    }

    void bindAsyncNodeServer(AsyncEndpointServer endpoint) {
        this.node = new AsyncNodeServerImpl(this, endpoint, 20);
    }

    void bindSyncNodeClient(SyncEndpointClient endpoint, ServerPushEventStrategy pluginObservationStrategy, ServerPushEventStrategy readerObservationStrategy) {
        this.node = new SyncNodeClientImpl(this, endpoint, pluginObservationStrategy, readerObservationStrategy);
    }

    void bindSyncNodeServer() {
        this.node = new SyncNodeServerImpl(this, 20);
    }

    void checkError(MessageDto message) {
        if (message.getAction().equals(MessageDto.Action.ERROR.name())) {
            BodyError body = (BodyError)KeypleGsonParser.getParser().fromJson(message.getBody(), BodyError.class);
            throw body.getException();
        }
    }

    String generateSessionId() {
        return UUID.randomUUID().toString();
    }
}

