/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AsyncNodeServer;
import org.eclipse.keyple.distributed.SyncNodeServer;
import org.eclipse.keyple.distributed.impl.PoolLocalServiceServerImpl;

public final class PoolLocalServiceServerUtils {
    private PoolLocalServiceServerUtils() {
    }

    public static AsyncNodeServer getAsyncNode() {
        return PoolLocalServiceServerUtils.getAsyncNode("defaultPoolLocalServiceServer");
    }

    public static AsyncNodeServer getAsyncNode(String serviceName) {
        Assert.getInstance().notNull((Object)serviceName, "service name");
        PoolLocalServiceServerImpl service = PoolLocalServiceServerUtils.getServiceImpl(serviceName);
        if (service.node instanceof AsyncNodeServer) {
            return (AsyncNodeServer)service.node;
        }
        throw new IllegalStateException("The PoolLocalServiceServer is not configured with a AsyncNodeServer");
    }

    public static SyncNodeServer getSyncNode() {
        return PoolLocalServiceServerUtils.getSyncNode("defaultPoolLocalServiceServer");
    }

    public static SyncNodeServer getSyncNode(String serviceName) {
        Assert.getInstance().notNull((Object)serviceName, "service name");
        PoolLocalServiceServerImpl service = PoolLocalServiceServerUtils.getServiceImpl(serviceName);
        if (service.node instanceof SyncNodeServer) {
            return (SyncNodeServer)service.node;
        }
        throw new IllegalStateException("The PoolLocalServiceServer is not configured with a SyncNodeServer");
    }

    private static PoolLocalServiceServerImpl getServiceImpl(String serviceName) {
        return PoolLocalServiceServerImpl.getInstance(serviceName);
    }
}

