/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.service.PoolPlugin;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.exception.KeypleAllocationReaderException;
import org.eclipse.keyple.core.service.exception.KeypleException;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.PoolLocalServiceServer;
import org.eclipse.keyple.distributed.impl.AbstractLocalService;

final class PoolLocalServiceServerImpl
extends AbstractLocalService
implements PoolLocalServiceServer {
    private static Map<String, PoolLocalServiceServerImpl> serviceByName;
    private final String[] poolPluginNames;

    private PoolLocalServiceServerImpl(String[] poolPluginNames) {
        this.poolPluginNames = poolPluginNames;
    }

    static PoolLocalServiceServerImpl createInstance(String serviceName, String[] poolPluginNames) {
        if (serviceByName == null) {
            serviceByName = new ConcurrentHashMap<String, PoolLocalServiceServerImpl>();
        }
        if (serviceByName.containsKey(serviceName)) {
            throw new IllegalArgumentException("A PoolLocalServiceServer already exists with the same name : " + serviceName);
        }
        PoolLocalServiceServerImpl instance = new PoolLocalServiceServerImpl(poolPluginNames);
        serviceByName.put(serviceName, instance);
        return instance;
    }

    static PoolLocalServiceServerImpl getInstance(String serviceName) {
        if (!serviceByName.containsKey(serviceName)) {
            throw new IllegalStateException("No PoolLocalServiceServer could be found with the provided name : " + serviceName);
        }
        return serviceByName.get(serviceName);
    }

    void onMessage(MessageDto msg) {
        MessageDto response;
        try {
            switch (MessageDto.Action.valueOf((String)msg.getAction())) {
                case ALLOCATE_READER: {
                    String groupReference = ((JsonObject)KeypleGsonParser.getParser().fromJson(msg.getBody(), JsonObject.class)).get("groupReference").getAsString();
                    PoolPlugin poolPlugin = this.getAPoolPlugin(groupReference);
                    ProxyReader reader = (ProxyReader)poolPlugin.allocateReader(groupReference);
                    response = new MessageDto(msg).setLocalReaderName(reader.getName()).setBody(null);
                    break;
                }
                case RELEASE_READER: {
                    this.releaseReader(msg.getLocalReaderName());
                    response = new MessageDto(msg).setBody(null);
                    break;
                }
                case GET_READER_GROUP_REFERENCES: {
                    SortedSet<String> groupReferences = this.getAllGroupReferences();
                    JsonObject body = new JsonObject();
                    body.add("readerGroupReferences", KeypleGsonParser.getParser().toJsonTree(groupReferences));
                    response = new MessageDto(msg).setBody(body.toString());
                    break;
                }
                default: {
                    ProxyReader reader = this.findReader(msg.getLocalReaderName());
                    response = this.executeLocally(reader, msg);
                    break;
                }
            }
        }
        catch (KeypleException e) {
            response = new MessageDto(msg).setAction(MessageDto.Action.ERROR.name()).setBody(KeypleGsonParser.getParser().toJson((Object)new BodyError((RuntimeException)((Object)e))));
        }
        this.node.sendMessage(response);
    }

    private PoolPlugin getAPoolPlugin(String groupReference) {
        for (String poolPluginName : this.poolPluginNames) {
            PoolPlugin poolPlugin = (PoolPlugin)SmartCardService.getInstance().getPlugin(poolPluginName);
            if (!poolPlugin.getReaderGroupReferences().contains(groupReference)) continue;
            return poolPlugin;
        }
        throw new KeypleAllocationReaderException("No reader pool plugin containing group reference '" + groupReference + "' is registered in this service");
    }

    private SortedSet<String> getAllGroupReferences() {
        TreeSet<String> allGroupReferences = new TreeSet<String>();
        for (String poolPluginName : this.poolPluginNames) {
            PoolPlugin poolPlugin = (PoolPlugin)SmartCardService.getInstance().getPlugin(poolPluginName);
            allGroupReferences.addAll(poolPlugin.getReaderGroupReferences());
        }
        return allGroupReferences;
    }

    private void releaseReader(String readerName) {
        for (String poolPluginName : this.poolPluginNames) {
            PoolPlugin poolPlugin = (PoolPlugin)SmartCardService.getInstance().getPlugin(poolPluginName);
            if (!poolPlugin.getReaderNames().contains(readerName)) continue;
            poolPlugin.releaseReader(poolPlugin.getReader(readerName));
            return;
        }
        throw new KeypleReaderNotFoundException(readerName);
    }

    private ProxyReader findReader(String localReaderName) {
        for (String poolPluginName : this.poolPluginNames) {
            PoolPlugin plugin = (PoolPlugin)SmartCardService.getInstance().getPlugin(poolPluginName);
            try {
                return (ProxyReader)plugin.getReader(localReaderName);
            }
            catch (KeypleReaderNotFoundException keypleReaderNotFoundException) {
            }
        }
        throw new KeypleReaderNotFoundException(localReaderName);
    }
}

