/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PoolPlugin;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.PoolLocalServiceServer;
import org.eclipse.keyple.distributed.impl.PoolLocalServiceServerImpl;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoolLocalServiceServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(PoolLocalServiceServerFactory.class);
    static final String DEFAULT_SERVICE_NAME = "defaultPoolLocalServiceServer";

    private PoolLocalServiceServerFactory() {
    }

    public static NameStep builder() {
        return new Step();
    }

    private static class Step
    implements NameStep,
    NodeStep,
    BuilderStep,
    PluginStep {
        private AsyncEndpointServer asyncEndpoint;
        private String[] poolPluginNames;
        private String serviceName;

        private Step() {
        }

        @Override
        public NodeStep withServiceName(String serviceName) {
            Assert.getInstance().notNull((Object)serviceName, "serviceName");
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public NodeStep withDefaultServiceName() {
            this.serviceName = PoolLocalServiceServerFactory.DEFAULT_SERVICE_NAME;
            return this;
        }

        @Override
        public PluginStep withAsyncNode(AsyncEndpointServer endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.asyncEndpoint = endpoint;
            return this;
        }

        @Override
        public PluginStep withSyncNode() {
            return this;
        }

        @Override
        public BuilderStep withPoolPlugins(String ... poolPluginNames) {
            Assert.getInstance().notNull((Object)poolPluginNames, "poolPluginNames");
            for (String poolPluginName : poolPluginNames) {
                Plugin plugin = SmartCardService.getInstance().getPlugin(poolPluginName);
                if (plugin instanceof PoolPlugin) continue;
                throw new IllegalArgumentException("Invalid plugin type for plugin " + poolPluginName + ", only ReaderPoolPlugin are valid");
            }
            this.poolPluginNames = poolPluginNames;
            return this;
        }

        @Override
        public PoolLocalServiceServer getService() {
            PoolLocalServiceServerImpl poolLocalServiceServerImpl = PoolLocalServiceServerImpl.createInstance(this.serviceName, this.poolPluginNames);
            if (this.asyncEndpoint != null) {
                poolLocalServiceServerImpl.bindAsyncNodeServer(this.asyncEndpoint);
                logger.info("Create a new PoolLocalServiceServer with a AsyncNodeServer");
            } else {
                poolLocalServiceServerImpl.bindSyncNodeServer();
                logger.info("Create a new PoolLocalServiceServer with a SyncNodeServer");
            }
            return poolLocalServiceServerImpl;
        }
    }

    public static interface PluginStep {
        public BuilderStep withPoolPlugins(String ... var1);
    }

    public static interface NodeStep {
        public PluginStep withAsyncNode(AsyncEndpointServer var1);

        public PluginStep withSyncNode();
    }

    public static interface NameStep {
        public NodeStep withServiceName(String var1);

        public NodeStep withDefaultServiceName();
    }

    public static interface BuilderStep {
        public PoolLocalServiceServer getService();
    }
}

