/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AsyncNodeClient;
import org.eclipse.keyple.distributed.LocalServiceClient;
import org.eclipse.keyple.distributed.impl.LocalServiceClientImpl;

public final class LocalServiceClientUtils {
    private LocalServiceClientUtils() {
    }

    public static LocalServiceClient getLocalService() {
        return LocalServiceClientUtils.getServiceImpl("defaultLocalServiceClient");
    }

    public static LocalServiceClient getLocalService(String serviceName) {
        Assert.getInstance().notNull((Object)serviceName, "serviceName");
        return LocalServiceClientUtils.getServiceImpl(serviceName);
    }

    public static AsyncNodeClient getAsyncNode() {
        return LocalServiceClientUtils.getAsyncNode("defaultLocalServiceClient");
    }

    public static AsyncNodeClient getAsyncNode(String serviceName) {
        Assert.getInstance().notNull((Object)serviceName, "serviceName");
        LocalServiceClientImpl service = LocalServiceClientUtils.getServiceImpl(serviceName);
        if (service.node instanceof AsyncNodeClient) {
            return (AsyncNodeClient)service.node;
        }
        throw new IllegalStateException("The LocalServiceClient is not configured with a AsyncNodeClient");
    }

    private static LocalServiceClientImpl getServiceImpl(String serviceName) {
        return LocalServiceClientImpl.getInstance(serviceName);
    }
}

