/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.LocalServiceClient;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.RemoteServiceParameters;
import org.eclipse.keyple.distributed.impl.AbstractLocalService;
import org.eclipse.keyple.distributed.spi.DoNotPropagateEventException;
import org.eclipse.keyple.distributed.spi.ObservableReaderEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalServiceClientImpl
extends AbstractLocalService
implements ObservableReader.ReaderObserver,
LocalServiceClient {
    private static final Logger logger = LoggerFactory.getLogger(LocalServiceClientImpl.class);
    private static Map<String, LocalServiceClientImpl> serviceByName;
    private final boolean withReaderObservation;
    private final ObservableReaderEventFilter eventFilter;
    private final Map<String, String> remoteReaderByLocalName;

    private LocalServiceClientImpl(boolean withReaderObservation, ObservableReaderEventFilter eventFilter) {
        this.withReaderObservation = withReaderObservation;
        this.eventFilter = eventFilter;
        this.remoteReaderByLocalName = new ConcurrentHashMap<String, String>();
    }

    static LocalServiceClientImpl createInstance(String serviceName, boolean withReaderObservation, ObservableReaderEventFilter eventFilter) {
        if (serviceByName == null) {
            serviceByName = new ConcurrentHashMap<String, LocalServiceClientImpl>();
        }
        if (serviceByName.containsKey(serviceName)) {
            throw new IllegalArgumentException("A LocalServiceClient already exists with the same name : " + serviceName);
        }
        LocalServiceClientImpl localService = new LocalServiceClientImpl(withReaderObservation, eventFilter);
        serviceByName.put(serviceName, localService);
        return localService;
    }

    static LocalServiceClientImpl getInstance(String serviceName) {
        if (!serviceByName.containsKey(serviceName)) {
            throw new IllegalStateException("No LocalServiceClient could be found with the provided name : " + serviceName);
        }
        return serviceByName.get(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public <T> T executeRemoteService(RemoteServiceParameters parameters, Class<T> classOfT) {
        Assert.getInstance().notNull((Object)parameters, "parameters").notNull(classOfT, "classOfT");
        localReader = (ProxyReader)parameters.getLocalReader();
        if (LocalServiceClientImpl.logger.isTraceEnabled()) {
            LocalServiceClientImpl.logger.trace("Execute remoteService {} for local reader {}", (Object)parameters.getServiceId(), (Object)localReader.getName());
        }
        sessionId = this.generateSessionId();
        remoteServiceDto = this.buildRemoteServiceMessage(parameters, sessionId);
        try {
            this.node.openSession(sessionId);
            receivedDto = this.node.sendRequest(remoteServiceDto);
            if (!this.withReaderObservation) ** GOTO lbl30
            if (localReader instanceof ObservableReader) {
                this.remoteReaderByLocalName.put(localReader.getName(), receivedDto.getRemoteReaderName());
                try {
                    if (LocalServiceClientImpl.logger.isTraceEnabled()) {
                        LocalServiceClientImpl.logger.trace("Add LocalServiceClient as an observer for reader {}", (Object)localReader.getName());
                    }
                    ((ObservableReader)localReader).addObserver((ObservableReader.ReaderObserver)this);
                    receivedDto = this.processTransaction(localReader, receivedDto);
                    userOutputData = this.extractUserOutputData(receivedDto, classOfT);
                    if (!this.canUnregisterRemoteReader(receivedDto)) ** GOTO lbl32
                    this.remoteReaderByLocalName.remove(localReader.getName());
                }
                catch (RuntimeException e) {
                    this.remoteReaderByLocalName.remove(localReader.getName());
                    throw e;
                }
            } else {
                throw new IllegalArgumentException("Observation can not be activated because local reader is not observable");
lbl30:
                // 1 sources

                receivedDto = this.processTransaction(localReader, receivedDto);
                userOutputData = this.extractUserOutputData(receivedDto, classOfT);
            }
lbl32:
            // 3 sources

            var8_9 = userOutputData;
            return var8_9;
        }
        finally {
            this.node.closeSessionSilently(sessionId);
        }
    }

    void onMessage(MessageDto msg) {
        throw new UnsupportedOperationException("onMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ReaderEvent event) {
        Object userData;
        try {
            userData = this.eventFilter.beforePropagation(event);
        }
        catch (DoNotPropagateEventException e) {
            logger.info("The propagation of the reader event [{}] is cancelled by the user's event filter", (Object)event.getEventType().name());
            return;
        }
        try {
            ProxyReader localReader = this.findLocalReader(event.getReaderName());
            String sessionId = this.generateSessionId();
            MessageDto eventMessageDto = this.buildEventMessage(event, userData, sessionId);
            try {
                this.node.openSession(sessionId);
                MessageDto receivedDto = this.node.sendRequest(eventMessageDto);
                receivedDto = this.processTransaction(localReader, receivedDto);
                Object userOutputData = this.extractUserOutputData(receivedDto, this.eventFilter.getUserOutputDataClass());
                if (this.canUnregisterRemoteReader(receivedDto)) {
                    this.remoteReaderByLocalName.remove(localReader.getName());
                }
                this.eventFilter.afterPropagation(userOutputData);
            }
            finally {
                this.node.closeSessionSilently(sessionId);
            }
        }
        catch (RuntimeException e) {
            this.remoteReaderByLocalName.remove(event.getReaderName());
            throw e;
        }
    }

    private MessageDto processTransaction(ProxyReader localReader, MessageDto receivedDto) {
        while (!receivedDto.getAction().equals(MessageDto.Action.TERMINATE_SERVICE.name()) && !receivedDto.getAction().equals(MessageDto.Action.ERROR.name())) {
            MessageDto responseDto = this.executeLocally(localReader, receivedDto);
            receivedDto = this.node.sendRequest(responseDto);
        }
        this.checkError(receivedDto);
        return receivedDto;
    }

    private <T> T extractUserOutputData(MessageDto msg, Class<T> classOfT) {
        if (classOfT == null) {
            return null;
        }
        Gson parser = KeypleGsonParser.getParser();
        JsonObject body = (JsonObject)parser.fromJson(msg.getBody(), JsonObject.class);
        return (T)parser.fromJson(body.get("userOutputData").getAsString(), classOfT);
    }

    private boolean canUnregisterRemoteReader(MessageDto msg) {
        Gson parser = KeypleGsonParser.getParser();
        JsonObject body = (JsonObject)parser.fromJson(msg.getBody(), JsonObject.class);
        return (Boolean)parser.fromJson(body.get("unregisterRemoteReader"), Boolean.class);
    }

    private MessageDto buildRemoteServiceMessage(RemoteServiceParameters parameters, String sessionId) {
        AbstractSmartCard initialCardContent;
        JsonObject body = new JsonObject();
        body.addProperty("serviceId", parameters.getServiceId());
        Object userInputData = parameters.getUserInputData();
        if (userInputData != null) {
            body.add("userInputData", KeypleGsonParser.getParser().toJsonTree(userInputData));
        }
        if ((initialCardContent = parameters.getInitialCardContent()) != null) {
            body.add("initialCardContent", KeypleGsonParser.getParser().toJsonTree((Object)initialCardContent));
        }
        body.addProperty("isObservable", Boolean.valueOf(this.withReaderObservation && parameters.getLocalReader() instanceof ObservableReader));
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.EXECUTE_REMOTE_SERVICE.name()).setLocalReaderName(parameters.getLocalReader().getName()).setBody(body.toString());
    }

    private MessageDto buildEventMessage(ReaderEvent readerEvent, Object userInputData, String sessionId) {
        JsonObject body = new JsonObject();
        body.add("readerEvent", KeypleGsonParser.getParser().toJsonTree((Object)readerEvent));
        body.add("userInputData", KeypleGsonParser.getParser().toJsonTree(userInputData));
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.READER_EVENT.name()).setLocalReaderName(readerEvent.getReaderName()).setRemoteReaderName(this.remoteReaderByLocalName.get(readerEvent.getReaderName())).setBody(body.toString());
    }
}

