/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.LocalServiceClient;
import org.eclipse.keyple.distributed.impl.LocalServiceClientImpl;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClient;
import org.eclipse.keyple.distributed.spi.ObservableReaderEventFilter;
import org.eclipse.keyple.distributed.spi.SyncEndpointClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalServiceClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(LocalServiceClientFactory.class);
    private static final int DEFAULT_TIMEOUT = 5;
    static final String DEFAULT_SERVICE_NAME = "defaultLocalServiceClient";

    private LocalServiceClientFactory() {
    }

    public static NameStep builder() {
        return new Step();
    }

    private static class Step
    implements NameStep,
    NodeStep,
    ReaderStep,
    BuilderStep,
    TimeoutStep {
        private AsyncEndpointClient asyncEndpoint;
        private SyncEndpointClient syncEndpoint;
        private Boolean withReaderObservation;
        private ObservableReaderEventFilter eventFilter;
        private int timeoutInSec;
        private String serviceName;

        private Step() {
        }

        @Override
        public NodeStep withServiceName(String serviceName) {
            Assert.getInstance().notNull((Object)serviceName, "serviceName");
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public NodeStep withDefaultServiceName() {
            this.serviceName = LocalServiceClientFactory.DEFAULT_SERVICE_NAME;
            return this;
        }

        @Override
        public TimeoutStep withAsyncNode(AsyncEndpointClient endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.asyncEndpoint = endpoint;
            return this;
        }

        @Override
        public ReaderStep withSyncNode(SyncEndpointClient endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.syncEndpoint = endpoint;
            return this;
        }

        @Override
        public BuilderStep withoutReaderObservation() {
            this.withReaderObservation = false;
            return this;
        }

        @Override
        public BuilderStep withReaderObservation(ObservableReaderEventFilter eventFilter) {
            Assert.getInstance().notNull((Object)eventFilter, "eventFilter");
            this.withReaderObservation = true;
            this.eventFilter = eventFilter;
            return this;
        }

        @Override
        public LocalServiceClient getService() {
            LocalServiceClientImpl service = LocalServiceClientImpl.createInstance(this.serviceName, this.withReaderObservation, this.eventFilter);
            if (this.asyncEndpoint != null) {
                logger.info("Create a new LocalServiceClientImpl with a AsyncNodeClient and withReaderObservation={}", (Object)this.withReaderObservation);
                service.bindAsyncNodeClient(this.asyncEndpoint, this.timeoutInSec);
            } else {
                logger.info("Create a new LocalServiceClientImpl with a SyncNodeClient and withReaderObservation={}", (Object)this.withReaderObservation);
                service.bindSyncNodeClient(this.syncEndpoint, null, null);
            }
            return service;
        }

        @Override
        public ReaderStep usingDefaultTimeout() {
            this.timeoutInSec = 5;
            return this;
        }

        @Override
        public ReaderStep usingTimeout(int timeoutInSeconds) {
            this.timeoutInSec = timeoutInSeconds;
            return this;
        }
    }

    public static interface ReaderStep {
        public BuilderStep withReaderObservation(ObservableReaderEventFilter var1);

        public BuilderStep withoutReaderObservation();
    }

    public static interface TimeoutStep {
        public ReaderStep usingDefaultTimeout();

        public ReaderStep usingTimeout(int var1);
    }

    public static interface NodeStep {
        public TimeoutStep withAsyncNode(AsyncEndpointClient var1);

        public ReaderStep withSyncNode(SyncEndpointClient var1);
    }

    public static interface NameStep {
        public NodeStep withServiceName(String var1);

        public NodeStep withDefaultServiceName();
    }

    public static interface BuilderStep {
        public LocalServiceClient getService();
    }
}

