/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.DefaultSelectionsRequest;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsRequest;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.impl.AbstractMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLocalService
extends AbstractMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLocalService.class);

    AbstractLocalService() {
    }

    ProxyReader findLocalReader(String localReaderName) {
        if (logger.isTraceEnabled()) {
            logger.trace("Try to find local reader by name '{}' in {} plugin(s)", (Object)localReaderName, (Object)SmartCardService.getInstance().getPlugins().size());
        }
        for (Plugin plugin : SmartCardService.getInstance().getPlugins().values()) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Try to find local reader '{}' in plugin '{}'", (Object)localReaderName, (Object)plugin.getName());
                }
                return (ProxyReader)plugin.getReader(localReaderName);
            }
            catch (KeypleReaderNotFoundException keypleReaderNotFoundException) {
            }
        }
        throw new KeypleReaderNotFoundException(localReaderName);
    }

    MessageDto executeLocally(ProxyReader localReader, MessageDto msg) {
        return new LocalReaderExecutor(localReader, msg).execute();
    }

    private static final class LocalReaderExecutor {
        private static final String POLLING_MODE = "pollingMode";
        private final ProxyReader reader;
        private final MessageDto msg;
        private final MessageDto.Action action;

        private LocalReaderExecutor(ProxyReader reader, MessageDto msg) {
            this.reader = reader;
            this.msg = msg;
            this.action = MessageDto.Action.valueOf((String)msg.getAction());
        }

        private MessageDto execute() {
            MessageDto response;
            try {
                switch (this.action) {
                    case TRANSMIT: {
                        response = this.transmit();
                        break;
                    }
                    case TRANSMIT_CARD_SELECTION: {
                        response = this.transmitCardSelectionRequests();
                        break;
                    }
                    case SET_DEFAULT_SELECTION: {
                        response = this.setDefaultSelection();
                        break;
                    }
                    case IS_CARD_PRESENT: {
                        response = this.isCardPresent();
                        break;
                    }
                    case IS_READER_CONTACTLESS: {
                        response = this.isReaderContactless();
                        break;
                    }
                    case START_CARD_DETECTION: {
                        response = this.startCardDetection();
                        break;
                    }
                    case STOP_CARD_DETECTION: {
                        response = this.stopCardDetection();
                        break;
                    }
                    case FINALIZE_CARD_PROCESSING: {
                        response = this.finalizeCardProcessing();
                        break;
                    }
                    case RELEASE_CHANNEL: {
                        response = this.releaseChannel();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(this.action.name());
                    }
                }
            }
            catch (KeypleReaderIOException e) {
                response = new MessageDto(this.msg).setAction(MessageDto.Action.ERROR.name()).setBody(KeypleGsonParser.getParser().toJson((Object)new BodyError((RuntimeException)((Object)e))));
            }
            return response;
        }

        private MessageDto transmit() {
            JsonObject bodyObject = (JsonObject)KeypleGsonParser.getParser().fromJson(this.msg.getBody(), JsonObject.class);
            ChannelControl channelControl = ChannelControl.valueOf((String)bodyObject.get("channelControl").getAsString());
            CardRequest cardRequest = (CardRequest)KeypleGsonParser.getParser().fromJson(bodyObject.get("cardRequest").getAsString(), CardRequest.class);
            if (logger.isTraceEnabled()) {
                logger.trace("Execute locally cardRequest : {} with params {} on reader {}", new Object[]{cardRequest, channelControl, this.reader.getName()});
            }
            CardResponse cardResponse = this.reader.transmitCardRequest(cardRequest, channelControl);
            String body = KeypleGsonParser.getParser().toJson((Object)cardResponse, CardResponse.class);
            return new MessageDto(this.msg).setBody(body);
        }

        private MessageDto transmitCardSelectionRequests() {
            JsonObject bodyJsonO = (JsonObject)KeypleGsonParser.getParser().fromJson(this.msg.getBody(), JsonObject.class);
            List cardSelectionRequests = (List)KeypleGsonParser.getParser().fromJson(bodyJsonO.get("cardSelectionRequests").getAsString(), new TypeToken<ArrayList<CardSelectionRequest>>(){}.getType());
            MultiSelectionProcessing multiSelectionProcessing = MultiSelectionProcessing.valueOf((String)bodyJsonO.get("multiSelectionProcessing").getAsString());
            ChannelControl channelControl = ChannelControl.valueOf((String)bodyJsonO.get("channelControl").getAsString());
            if (logger.isTraceEnabled()) {
                logger.trace("Execute locally cardSelectionRequests : {} with params {} {}", new Object[]{cardSelectionRequests, channelControl, multiSelectionProcessing});
            }
            List cardSelectionResponses = this.reader.transmitCardSelectionRequests(cardSelectionRequests, multiSelectionProcessing, channelControl);
            String body = KeypleGsonParser.getParser().toJson((Object)cardSelectionResponses, new TypeToken<ArrayList<CardSelectionResponse>>(){}.getType());
            return new MessageDto(this.msg).setBody(body);
        }

        private MessageDto setDefaultSelection() {
            String pollingModeJson;
            ObservableReader observableReader = (ObservableReader)this.reader;
            JsonObject body = (JsonObject)KeypleGsonParser.getParser().fromJson(this.msg.getBody(), JsonObject.class);
            DefaultSelectionsRequest defaultSelectionsRequest = (DefaultSelectionsRequest)KeypleGsonParser.getParser().fromJson(body.get("defaultSelectionsRequest"), DefaultSelectionsRequest.class);
            ObservableReader.NotificationMode notificationMode = ObservableReader.NotificationMode.valueOf((String)body.get("notificationMode").getAsString());
            boolean hasPollingMode = false;
            ObservableReader.PollingMode pollingMode = null;
            String string = pollingModeJson = body.has(POLLING_MODE) ? body.get(POLLING_MODE).getAsString() : null;
            if (pollingModeJson != null) {
                hasPollingMode = true;
                pollingMode = ObservableReader.PollingMode.valueOf((String)pollingModeJson);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Execute locally set DefaultSelectionExecutor on reader : {} with params {} {} {}", new Object[]{observableReader.getName(), defaultSelectionsRequest, notificationMode != null ? notificationMode : "no-notificationMode", hasPollingMode ? pollingMode : "no-pollingMode"});
            }
            if (hasPollingMode) {
                observableReader.setDefaultSelectionRequest((AbstractDefaultSelectionsRequest)defaultSelectionsRequest, notificationMode, pollingMode);
            } else {
                observableReader.setDefaultSelectionRequest((AbstractDefaultSelectionsRequest)defaultSelectionsRequest, notificationMode);
            }
            return new MessageDto(this.msg).setBody(null);
        }

        private MessageDto isCardPresent() {
            boolean isSePresent = this.reader.isCardPresent();
            String body = KeypleGsonParser.getParser().toJson((Object)isSePresent, Boolean.class);
            return new MessageDto(this.msg).setBody(body);
        }

        private MessageDto isReaderContactless() {
            boolean isContactless = this.reader.isContactless();
            String body = KeypleGsonParser.getParser().toJson((Object)isContactless, Boolean.class);
            return new MessageDto(this.msg).setBody(body);
        }

        private MessageDto startCardDetection() {
            JsonObject body = (JsonObject)KeypleGsonParser.getParser().fromJson(this.msg.getBody(), JsonObject.class);
            ObservableReader.PollingMode pollingMode = ObservableReader.PollingMode.valueOf((String)body.get(POLLING_MODE).getAsString());
            ((ObservableReader)this.reader).startCardDetection(pollingMode);
            return new MessageDto(this.msg).setBody(null);
        }

        private MessageDto stopCardDetection() {
            ((ObservableReader)this.reader).stopCardDetection();
            return new MessageDto(this.msg).setBody(null);
        }

        private MessageDto finalizeCardProcessing() {
            ((ObservableReader)this.reader).finalizeCardProcessing();
            return new MessageDto(this.msg).setBody(null);
        }

        private MessageDto releaseChannel() {
            this.reader.releaseChannel();
            return new MessageDto(this.msg).setBody(null);
        }
    }
}

