/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.util.Assert;

public class RemoteServiceParameters {
    private final String serviceId;
    private final Reader localReader;
    private final Object userInputData;
    private final AbstractSmartCard initialCardContent;

    private RemoteServiceParameters(Builder builder) {
        Assert.getInstance().notEmpty(builder.serviceId, "serviceId").notNull((Object)builder.localReader, "localReader");
        this.serviceId = builder.serviceId;
        this.localReader = builder.localReader;
        this.userInputData = builder.userInputData;
        this.initialCardContent = builder.initialCardContent;
    }

    public static Builder builder(String serviceId, Reader localReader) {
        return new Builder(serviceId, localReader);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Reader getLocalReader() {
        return this.localReader;
    }

    public Object getUserInputData() {
        return this.userInputData;
    }

    public AbstractSmartCard getInitialCardContent() {
        return this.initialCardContent;
    }

    public static class Builder {
        private final String serviceId;
        private final Reader localReader;
        private Object userInputData;
        private AbstractSmartCard initialCardContent;

        private Builder(String serviceId, Reader localReader) {
            this.serviceId = serviceId;
            this.localReader = localReader;
        }

        public Builder withUserInputData(Object userInputData) {
            this.userInputData = userInputData;
            return this;
        }

        public Builder withInitialCardContent(AbstractSmartCard initialCardContent) {
            this.initialCardContent = initialCardContent;
            return this;
        }

        public RemoteServiceParameters build() {
            return new RemoteServiceParameters(this);
        }
    }
}

