/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.SortedSet;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Sets;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.service.PoolPlugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.exception.KeypleAllocationReaderException;
import org.eclipse.keyple.core.service.exception.KeyplePluginNotFoundException;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.impl.BaseLocalTest;
import org.eclipse.keyple.distributed.impl.PoolLocalServiceServerFactory;
import org.eclipse.keyple.distributed.impl.PoolLocalServiceServerImpl;
import org.eclipse.keyple.distributed.impl.PoolLocalServiceServerUtils;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServer;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PoolLocalServiceServerTest
extends BaseLocalTest {
    PoolPlugin poolPluginMock;
    AsyncEndpointServer asyncServer;
    Gson parser;
    String groupReference = "1";
    final String clientNodeId = "clientNodeId1";
    final String remoteReaderName = "remoteReaderName1";
    final String sessionId = "session1";
    final SortedSet<String> groupReferences = Sets.newTreeSet((Object[])new String[]{this.groupReference});
    final String poolPluginName = "poolPluginMock";
    MessageDto response;
    String localServiceName;
    PoolLocalServiceServerImpl service;
    @Captor
    ArgumentCaptor<MessageDto> responseCaptor;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() {
        this.init();
        this.localServiceName = this.testName.getMethodName();
        this.parser = KeypleGsonParser.getParser();
        this.initMockService();
    }

    @After
    public void tearDown() {
        SmartCardService service = SmartCardService.getInstance();
        if (service.isRegistered("poolPluginMock")) {
            SmartCardService.getInstance().unregisterPlugin("poolPluginMock");
        }
    }

    @Test
    public void buildService_withAsyncNode() {
        this.service = (PoolLocalServiceServerImpl)PoolLocalServiceServerFactory.builder().withServiceName("aService_withAsyncNode").withAsyncNode(this.asyncServer).withPoolPlugins(new String[]{this.poolPluginMock.getName()}).getService();
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.service).isNotNull()).isEqualTo((Object)PoolLocalServiceServerImpl.getInstance((String)"aService_withAsyncNode"));
    }

    @Test
    public void buildService_withSyncNode() {
        this.service = (PoolLocalServiceServerImpl)PoolLocalServiceServerFactory.builder().withServiceName("aService_withSyncNode").withSyncNode().withPoolPlugins(new String[]{this.poolPluginMock.getName()}).getService();
        ((AbstractObjectAssert)Assertions.assertThat((Object)this.service).isNotNull()).isEqualTo((Object)PoolLocalServiceServerImpl.getInstance((String)"aService_withSyncNode"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildService_withNull_AsyncNode_throwIAE() {
        this.service = (PoolLocalServiceServerImpl)PoolLocalServiceServerFactory.builder().withServiceName(this.localServiceName).withAsyncNode(null).withPoolPlugins(new String[]{this.poolPluginMock.getName()}).getService();
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildService_withNoPluginName_throwIAE() {
        this.service = (PoolLocalServiceServerImpl)PoolLocalServiceServerFactory.builder().withServiceName(this.localServiceName).withAsyncNode(null).withPoolPlugins(new String[0]).getService();
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildService_withWrong_pluginType_throwIAE() {
        String readerMockName = "readerPlugin";
        SmartCardService.getInstance().registerPlugin(new PluginFactory(){

            public String getPluginName() {
                return "readerPlugin";
            }

            public Plugin getPlugin() {
                return (Plugin)Mockito.mock(Plugin.class);
            }
        });
        this.service = (PoolLocalServiceServerImpl)PoolLocalServiceServerFactory.builder().withServiceName(this.localServiceName).withAsyncNode(null).withPoolPlugins(new String[]{this.poolPluginMock.getName(), "readerPlugin"}).getService();
    }

    @Test
    public void onAllocateReader_shouldPropagate_toLocalPoolPlugin() {
        MessageDto request = this.getAllocateReaderDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(this.getAllocateReaderDto());
        this.response = this.captureResponse();
        PoolLocalServiceServerTest.assertMetadataMatches(request, this.response);
        Assertions.assertThat((String)this.readerMocked.getName()).isEqualTo((Object)this.response.getLocalReaderName());
    }

    @Test
    public void onAllocateReader_shouldPropagate_AllocationException() {
        KeypleAllocationReaderException e = new KeypleAllocationReaderException("");
        ((PoolPlugin)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)this.poolPluginMock)).allocateReader(this.groupReference);
        MessageDto request = this.getAllocateReaderDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(this.getAllocateReaderDto());
        this.response = this.captureResponse();
        PoolLocalServiceServerTest.assertMetadataMatches(request, this.response);
        Assertions.assertThat((Throwable)e).isEqualToComparingFieldByFieldRecursively((Object)this.getExceptionFromDto(this.response));
    }

    @Test
    public void onAllocateReader_withNoPlugin_shouldThrow_KPNFE() {
        SmartCardService.getInstance().unregisterPlugin("poolPluginMock");
        MessageDto request = this.getAllocateReaderDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(this.getAllocateReaderDto());
        this.response = this.captureResponse();
        PoolLocalServiceServerTest.assertMetadataMatches(request, this.response);
        Assertions.assertThat((Throwable)this.getExceptionFromDto(this.response)).isInstanceOf(KeyplePluginNotFoundException.class);
    }

    @Test
    public void onReleaseReader_shouldPropagate_toLocalPoolPlugin() {
        MessageDto request = this.getReleaseReaderDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(request);
        ((PoolPlugin)Mockito.verify((Object)this.poolPluginMock, (VerificationMode)Mockito.times((int)1))).releaseReader((Reader)this.readerMocked);
    }

    @Test
    public void onReleaseReader_withNoPlugin_shouldThrow_KPNFE() {
        ((PoolPlugin)Mockito.doReturn((Object)Sets.newTreeSet()).when((Object)this.poolPluginMock)).getReaderNames();
        MessageDto request = this.getReleaseReaderDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(request);
        this.response = this.captureResponse();
        PoolLocalServiceServerTest.assertMetadataMatches(request, this.response);
        Assertions.assertThat((Throwable)this.getExceptionFromDto(this.response)).isInstanceOf(KeypleReaderNotFoundException.class);
    }

    @Test
    public void onGroupReferences_shouldPropagate_toLocalPoolPlugin() {
        MessageDto request = this.getGroupReferencesDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(request);
        this.response = this.captureResponse();
        PoolLocalServiceServerTest.assertMetadataMatches(request, this.response);
        Assertions.assertThat(this.getReferenceGroupFromDto(this.response)).containsExactly((Object[])new String[]{this.groupReference});
    }

    @Test
    public void onGroupReferences_shouldPropagate_AllocationError() {
        MessageDto request = this.getGroupReferencesDto();
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(request);
        this.response = this.captureResponse();
        PoolLocalServiceServerTest.assertMetadataMatches(request, this.response);
        Assertions.assertThat(this.getReferenceGroupFromDto(this.response)).containsExactly((Object[])new String[]{this.groupReference});
    }

    @Test
    public void onIsPresent_shouldPropagate_toLocalPoolPlugin() {
        MessageDto request = PoolLocalServiceServerTest.getIsCardPresentDto("session1");
        PoolLocalServiceServerUtils.getAsyncNode((String)this.localServiceName).onMessage(request);
        this.response = this.captureResponse();
        MessageDto response = (MessageDto)this.responseCaptor.getValue();
        PoolLocalServiceServerTest.assertMetadataMatches(request, response);
    }

    private void initMockService() {
        this.poolPluginMock = (PoolPlugin)Mockito.mock(PoolPlugin.class);
        ((PoolPlugin)Mockito.doReturn((Object)this.readerMocked).when((Object)this.poolPluginMock)).allocateReader(this.groupReference);
        ((PoolPlugin)Mockito.doReturn((Object)this.readerMocked).when((Object)this.poolPluginMock)).getReader("readerName");
        ((PoolPlugin)Mockito.doReturn((Object)Sets.newTreeSet((Object[])new String[]{"readerName"})).when((Object)this.poolPluginMock)).getReaderNames();
        ((PoolPlugin)Mockito.doReturn((Object)"poolPluginMock").when((Object)this.poolPluginMock)).getName();
        ((PoolPlugin)Mockito.doReturn(this.groupReferences).when((Object)this.poolPluginMock)).getReaderGroupReferences();
        this.asyncServer = (AsyncEndpointServer)Mockito.mock(AsyncEndpointServer.class);
        SmartCardService.getInstance().registerPlugin(new PluginFactory(){

            public String getPluginName() {
                return "poolPluginMock";
            }

            public Plugin getPlugin() {
                return PoolLocalServiceServerTest.this.poolPluginMock;
            }
        });
        this.service = (PoolLocalServiceServerImpl)PoolLocalServiceServerFactory.builder().withServiceName(this.localServiceName).withAsyncNode(this.asyncServer).withPoolPlugins(new String[]{this.poolPluginMock.getName()}).getService();
    }

    private MessageDto getAllocateReaderDto() {
        JsonObject body = new JsonObject();
        body.addProperty("groupReference", this.groupReference);
        return new MessageDto().setAction(MessageDto.Action.ALLOCATE_READER.name()).setClientNodeId("clientNodeId1").setSessionId("session1").setBody(body.toString());
    }

    private MessageDto getReleaseReaderDto() {
        return new MessageDto().setAction(MessageDto.Action.RELEASE_READER.name()).setClientNodeId("clientNodeId1").setSessionId("session1").setLocalReaderName("readerName").setRemoteReaderName("remoteReaderName1").setBody(null);
    }

    private MessageDto getGroupReferencesDto() {
        return new MessageDto().setAction(MessageDto.Action.GET_READER_GROUP_REFERENCES.name()).setClientNodeId("clientNodeId1").setSessionId("session1").setBody(null);
    }

    public static void assertMetadataMatches(MessageDto request, MessageDto response) {
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((String)response.getSessionId()).isEqualTo((Object)request.getSessionId());
        Assertions.assertThat((String)response.getClientNodeId()).isEqualTo((Object)request.getClientNodeId());
    }

    public static MessageDto getIsCardPresentDto(String sessionId) {
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.IS_CARD_PRESENT.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setLocalReaderName("readerName").setBody(null);
    }

    private SortedSet<String> getReferenceGroupFromDto(MessageDto msg) {
        String readerGroupReferencesJson = ((JsonObject)KeypleGsonParser.getParser().fromJson(msg.getBody(), JsonObject.class)).get("readerGroupReferences").toString();
        return (SortedSet)KeypleGsonParser.getParser().fromJson(readerGroupReferencesJson, SortedSet.class);
    }

    private RuntimeException getExceptionFromDto(MessageDto msg) {
        String bodyResponse = msg.getBody();
        return ((BodyError)KeypleGsonParser.getParser().fromJson(bodyResponse, BodyError.class)).getException();
    }

    private MessageDto captureResponse() {
        ((AsyncEndpointServer)Mockito.verify((Object)this.asyncServer)).sendMessage((MessageDto)this.responseCaptor.capture());
        return (MessageDto)this.responseCaptor.getValue();
    }
}

