/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.LocalServiceClient;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.RemoteServiceParameters;
import org.eclipse.keyple.distributed.impl.AbstractLocalServiceTest;
import org.eclipse.keyple.distributed.impl.BaseLocalTest;
import org.eclipse.keyple.distributed.impl.LocalServiceClientFactory;
import org.eclipse.keyple.distributed.impl.LocalServiceClientImpl;
import org.eclipse.keyple.distributed.impl.LocalServiceClientUtils;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClient;
import org.eclipse.keyple.distributed.spi.DoNotPropagateEventException;
import org.eclipse.keyple.distributed.spi.ObservableReaderEventFilter;
import org.eclipse.keyple.distributed.spi.SyncEndpointClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class LocalServiceClientTest
extends BaseLocalTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLocalServiceTest.class);
    SyncEndpointClient syncClientEndpoint;
    AsyncEndpointClient asyncClient;
    ObservableReaderEventFilter eventFilter;
    MyKeypleUserData outputData;
    MyKeypleUserData inputData;
    MatchingSeImpl matchingCard;
    PluginFactory mockFactory;
    ReaderEvent readerEvent;
    String pluginName = "mockPlugin";
    String serviceId = "serviceId";
    String remoteReaderName = "remoteReaderName";
    Gson parser;
    String localServiceName;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() {
        this.init();
        this.mockFactory = (PluginFactory)Mockito.mock(PluginFactory.class);
        Plugin readerPlugin = (Plugin)Mockito.mock(Plugin.class);
        ((PluginFactory)Mockito.doReturn((Object)readerPlugin).when((Object)this.mockFactory)).getPlugin();
        ((PluginFactory)Mockito.doReturn((Object)this.pluginName).when((Object)this.mockFactory)).getPluginName();
        ((Plugin)Mockito.doReturn((Object)this.pluginName).when((Object)readerPlugin)).getName();
        SmartCardService.getInstance().registerPlugin(this.mockFactory);
        this.syncClientEndpoint = (SyncEndpointClient)Mockito.mock(SyncEndpointClient.class);
        this.asyncClient = (AsyncEndpointClient)Mockito.mock(AsyncEndpointClient.class);
        this.eventFilter = (ObservableReaderEventFilter)Mockito.mock(ObservableReaderEventFilter.class);
        ((ProxyReader)Mockito.doReturn((Object)LocalServiceClientTest.getACardResponse()).when((Object)this.readerMocked)).transmitCardRequest((CardRequest)Mockito.any(CardRequest.class), (ChannelControl)Mockito.any(ChannelControl.class));
        ((BaseLocalTest.ObservableProxyReader)Mockito.doReturn((Object)LocalServiceClientTest.getACardResponse()).when((Object)this.observableReaderMocked)).transmitCardRequest((CardRequest)Mockito.any(CardRequest.class), (ChannelControl)Mockito.any(ChannelControl.class));
        ((Plugin)Mockito.doReturn((Object)this.observableReaderMocked).when((Object)readerPlugin)).getReader("observableReaderName");
        this.outputData = new MyKeypleUserData("output1");
        this.inputData = new MyKeypleUserData("input1");
        this.matchingCard = new MatchingSeImpl(LocalServiceClientTest.getACardSelectionResponse());
        this.readerEvent = new ReaderEvent(this.pluginName, "observableReaderName", ReaderEvent.EventType.CARD_INSERTED, null);
        this.parser = KeypleGsonParser.getParser();
        this.localServiceName = this.testName.getMethodName();
    }

    @After
    public void tearDown() {
        SmartCardService.getInstance().unregisterPlugin(this.pluginName);
    }

    @Test
    public void buildService_withSyncNode_withoutObservation() {
        LocalServiceClient service = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withoutReaderObservation().getService();
        ((AbstractObjectAssert)Assertions.assertThat((Object)service).isNotNull()).isEqualTo((Object)LocalServiceClientUtils.getLocalService((String)this.localServiceName));
    }

    @Test
    public void buildService_withAsyncNode_withoutReaderObservation() {
        LocalServiceClient service = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withAsyncNode(this.asyncClient).usingDefaultTimeout().withoutReaderObservation().getService();
        ((AbstractObjectAssert)Assertions.assertThat((Object)service).isNotNull()).isEqualTo((Object)LocalServiceClientUtils.getLocalService((String)this.localServiceName));
    }

    @Test(expected=IllegalArgumentException.class)
    public void executeService_withNullParam_throwException() {
        this.syncClientEndpoint = new SyncEndpointClientMock(1);
        LocalServiceClient localServiceClient = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withoutReaderObservation().getService();
        localServiceClient.executeRemoteService(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void executeService_withNullOutputData_throwException() {
        this.syncClientEndpoint = new SyncEndpointClientMock(1);
        LocalServiceClient localServiceClient = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withoutReaderObservation().getService();
        RemoteServiceParameters params = RemoteServiceParameters.builder((String)this.serviceId, (Reader)this.readerMocked).withUserInputData((Object)this.inputData).build();
        localServiceClient.executeRemoteService(params, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void executeService_activateObservation_withoutFilter_throwException() {
        this.syncClientEndpoint = new SyncEndpointClientMock(1);
        LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withReaderObservation(null).getService();
    }

    @Test
    public void executeService_activateObservation_withFilter_addObserver() {
        this.syncClientEndpoint = new SyncEndpointClientMock(1);
        LocalServiceClient localServiceClient = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withReaderObservation(this.eventFilter).getService();
        RemoteServiceParameters params = RemoteServiceParameters.builder((String)this.serviceId, (Reader)this.observableReaderMocked).build();
        localServiceClient.executeRemoteService(params, MyKeypleUserData.class);
        ((BaseLocalTest.ObservableProxyReader)Mockito.verify((Object)this.observableReaderMocked)).addObserver((ObservableReader.ReaderObserver)((LocalServiceClientImpl)localServiceClient));
    }

    @Test(expected=IllegalArgumentException.class)
    public void executeService_activateObservation_onNotObservableReader_throwException() {
        this.syncClientEndpoint = new SyncEndpointClientMock(1);
        LocalServiceClient localServiceClient = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withReaderObservation(this.eventFilter).getService();
        RemoteServiceParameters params = RemoteServiceParameters.builder((String)this.serviceId, (Reader)this.readerMocked).build();
        localServiceClient.executeRemoteService(params, MyKeypleUserData.class);
        ((BaseLocalTest.ObservableProxyReader)Mockito.verify((Object)this.observableReaderMocked, (VerificationMode)Mockito.times((int)1))).addObserver((ObservableReader.ReaderObserver)((LocalServiceClientImpl)localServiceClient));
    }

    @Test
    public void executeService_withSyncNode() {
        this.syncClientEndpoint = new SyncEndpointClientMock(2);
        LocalServiceClient localServiceClient = LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withoutReaderObservation().getService();
        RemoteServiceParameters params = RemoteServiceParameters.builder((String)this.serviceId, (Reader)this.readerMocked).withUserInputData((Object)this.inputData).withInitialCardContent((AbstractSmartCard)this.matchingCard).build();
        MyKeypleUserData output = (MyKeypleUserData)localServiceClient.executeRemoteService(params, MyKeypleUserData.class);
        Assertions.assertThat((int)((SyncEndpointClientMock)this.syncClientEndpoint).getRequests().size()).isEqualTo(2);
        MessageDto dtoRequest = ((SyncEndpointClientMock)this.syncClientEndpoint).getRequests().get(0);
        Assertions.assertThat((String)dtoRequest.getAction()).isEqualTo((Object)MessageDto.Action.EXECUTE_REMOTE_SERVICE.name());
        Assertions.assertThat((String)dtoRequest.getSessionId()).isNotEmpty();
        Assertions.assertThat((String)dtoRequest.getLocalReaderName()).isEqualTo((Object)"readerName");
        JsonObject body = (JsonObject)this.parser.fromJson(dtoRequest.getBody(), JsonObject.class);
        Assertions.assertThat((String)body.get("serviceId").getAsString()).isEqualTo((Object)this.serviceId);
        Assertions.assertThat((Object)this.parser.fromJson(body.get("userInputData"), MyKeypleUserData.class)).isEqualToComparingFieldByFieldRecursively((Object)this.inputData);
        Assertions.assertThat((Object)this.parser.fromJson(body.get("initialCardContent"), MatchingSeImpl.class)).isEqualToComparingFieldByFieldRecursively((Object)this.matchingCard);
        ((AbstractObjectAssert)Assertions.assertThat((Object)output).isNotNull()).isEqualToComparingFieldByField((Object)this.outputData);
    }

    @Test
    public void onUpdate_doNotPropagateEvent() {
        this.syncClientEndpoint = new SyncEndpointClientMock(2);
        LocalServiceClientImpl localClientService = (LocalServiceClientImpl)LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withReaderObservation((ObservableReaderEventFilter)new MyEventFilter(false)).getService();
        localClientService.update(this.readerEvent);
        Assertions.assertThat((int)((SyncEndpointClientMock)this.syncClientEndpoint).getRequests().size()).isZero();
    }

    @Test
    public void onUpdate_withSyncNode_unregisterReader() {
        this.syncClientEndpoint = new SyncEndpointClientMock(2);
        LocalServiceClientImpl localClientService = (LocalServiceClientImpl)LocalServiceClientFactory.builder().withServiceName(this.localServiceName).withSyncNode(this.syncClientEndpoint).withReaderObservation((ObservableReaderEventFilter)new MyEventFilter(true)).getService();
        localClientService.update(this.readerEvent);
        Assertions.assertThat((int)((SyncEndpointClientMock)this.syncClientEndpoint).getRequests().size()).isEqualTo(2);
        MessageDto dtoRequest = ((SyncEndpointClientMock)this.syncClientEndpoint).getRequests().get(0);
        Assertions.assertThat((String)dtoRequest.getAction()).isEqualTo((Object)MessageDto.Action.READER_EVENT.name());
        Assertions.assertThat((String)dtoRequest.getSessionId()).isNotEmpty();
        Assertions.assertThat((String)dtoRequest.getLocalReaderName()).isEqualTo((Object)"observableReaderName");
        JsonObject body = (JsonObject)KeypleGsonParser.getParser().fromJson(dtoRequest.getBody(), JsonObject.class);
        Assertions.assertThat((Object)KeypleGsonParser.getParser().fromJson(body.get("readerEvent").toString(), ReaderEvent.class)).isEqualToComparingFieldByField((Object)this.readerEvent);
        Assertions.assertThat((Object)this.parser.fromJson(body.get("userInputData"), MyKeypleUserData.class)).isEqualToComparingFieldByFieldRecursively((Object)this.inputData);
        Assertions.assertThat(LocalServiceClientTest.getMapOfRemoteReaderByLocalName((LocalServiceClient)localClientService)).isEmpty();
    }

    public static Map<String, String> getMapOfRemoteReaderByLocalName(LocalServiceClient service) {
        try {
            Field privateStringField = LocalServiceClientImpl.class.getDeclaredField("remoteReaderByLocalName");
            privateStringField.setAccessible(true);
            return (Map)privateStringField.get(service);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public MessageDto getTerminateDto(String sessionId, boolean unregister) {
        JsonObject body = new JsonObject();
        body.addProperty("userOutputData", this.parser.toJson((Object)this.outputData, MyKeypleUserData.class));
        body.addProperty("unregisterRemoteReader", this.parser.toJson((Object)unregister, Boolean.class));
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.TERMINATE_SERVICE.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setLocalReaderName("readerName").setRemoteReaderName(this.remoteReaderName).setBody(body.toString());
    }

    class MyEventFilter
    implements ObservableReaderEventFilter {
        Boolean propagateEvent;

        MyEventFilter(Boolean propagateEvent) {
            this.propagateEvent = propagateEvent;
        }

        public Object beforePropagation(ReaderEvent event) {
            if (this.propagateEvent.booleanValue()) {
                return LocalServiceClientTest.this.inputData;
            }
            throw new DoNotPropagateEventException("do not propagate event");
        }

        public Class<?> getUserOutputDataClass() {
            return MyKeypleUserData.class;
        }

        public void afterPropagation(Object userOutputData) {
            Assertions.assertThat((Object)userOutputData).isNotNull();
            Assertions.assertThat((Object)userOutputData).isEqualToComparingFieldByFieldRecursively((Object)LocalServiceClientTest.this.outputData);
        }
    }

    public static class MatchingSeImpl
    extends AbstractSmartCard {
        MatchingSeImpl(CardSelectionResponse selectionResponse) {
            super(selectionResponse);
        }
    }

    public static class MyKeypleUserData {
        final String field;

        MyKeypleUserData(String field) {
            this.field = field;
        }
    }

    class SyncEndpointClientMock
    implements SyncEndpointClient {
        final List<MessageDto> requests = new ArrayList<MessageDto>();
        Integer answerNumber;
        Integer answerIt;

        SyncEndpointClientMock(Integer answerNumber) {
            this.answerNumber = answerNumber;
            this.answerIt = 0;
        }

        public List<MessageDto> sendRequest(MessageDto msg) {
            logger.trace("Mock send a MessageDto request {}", (Object)msg);
            this.requests.add(msg);
            ArrayList<MessageDto> responses = new ArrayList<MessageDto>();
            if (this.answerNumber == 1) {
                responses.add(LocalServiceClientTest.this.getTerminateDto(msg.getSessionId(), true));
            }
            if (this.answerNumber > 1) {
                responses.add(BaseLocalTest.getTransmitDto(msg.getSessionId()));
                SyncEndpointClientMock syncEndpointClientMock = this;
                Integer n = syncEndpointClientMock.answerNumber;
                Integer n2 = syncEndpointClientMock.answerNumber = Integer.valueOf(syncEndpointClientMock.answerNumber - 1);
            }
            return responses;
        }

        public List<MessageDto> getRequests() {
            return this.requests;
        }
    }
}

