/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.eclipse.keyple.core.card.message.AnswerToReset;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.DefaultSelectionsRequest;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.message.SelectionStatus;
import org.eclipse.keyple.core.card.selection.CardSelector;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.mockito.Mockito;

public abstract class BaseLocalTest {
    protected static final String readerName = "readerName";
    final String readerNameUnknown = "readerNameUnknown";
    final String observableReaderName = "observableReaderName";
    ProxyReader readerMocked;
    ObservableProxyReader observableReaderMocked;

    public void init() {
        this.readerMocked = (ProxyReader)Mockito.mock(ProxyReader.class);
        this.observableReaderMocked = (ObservableProxyReader)Mockito.mock(ObservableProxyReader.class);
        ((ProxyReader)Mockito.doReturn((Object)readerName).when((Object)this.readerMocked)).getName();
        ((ObservableProxyReader)Mockito.lenient().doReturn((Object)"observableReaderName").when((Object)this.observableReaderMocked)).getName();
    }

    public static MessageDto getTransmitDto(String sessionId) {
        JsonObject body = new JsonObject();
        body.addProperty("channelControl", ChannelControl.CLOSE_AFTER.name());
        body.addProperty("cardRequest", KeypleGsonParser.getParser().toJson((Object)BaseLocalTest.getACardRequest()));
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.TRANSMIT.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(body.toString());
    }

    public static MessageDto getSetDefaultSelectionDto(String sessionId) {
        JsonObject body = new JsonObject();
        body.add("defaultSelectionsRequest", KeypleGsonParser.getParser().toJsonTree((Object)new DefaultSelectionsRequest((List)Lists.newArrayList((Object[])new CardSelectionRequest[]{BaseLocalTest.getACardSelectionRequest()}), MultiSelectionProcessing.FIRST_MATCH, ChannelControl.CLOSE_AFTER)));
        body.addProperty("notificationMode", ObservableReader.NotificationMode.MATCHED_ONLY.name());
        body.addProperty("pollingMode", ObservableReader.PollingMode.REPEATING.name());
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.SET_DEFAULT_SELECTION.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(body.toString());
    }

    public static MessageDto getTransmitCardSelectionsDto(String sessionId) {
        JsonObject body = new JsonObject();
        body.addProperty("channelControl", ChannelControl.CLOSE_AFTER.name());
        body.addProperty("cardSelectionRequests", KeypleGsonParser.getParser().toJson((Object)Lists.newArrayList((Object[])new CardRequest[]{BaseLocalTest.getACardRequest()})));
        body.addProperty("multiSelectionProcessing", MultiSelectionProcessing.FIRST_MATCH.name());
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.TRANSMIT_CARD_SELECTION.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(body.toString());
    }

    public static MessageDto getIsCardPresentDto(String sessionId) {
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.IS_CARD_PRESENT.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(null);
    }

    public static MessageDto getIsContactless(String sessionId) {
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.IS_READER_CONTACTLESS.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(null);
    }

    public static MessageDto getStartCardDetection(String sessionId) {
        JsonObject body = new JsonObject();
        body.addProperty("pollingMode", ObservableReader.PollingMode.REPEATING.name());
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.START_CARD_DETECTION.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(body.toString());
    }

    public static MessageDto getStopCardDetection(String sessionId) {
        JsonObject body = new JsonObject();
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.STOP_CARD_DETECTION.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(body.toString());
    }

    public static MessageDto getFinalizeCardProcessing(String sessionId) {
        JsonObject body = new JsonObject();
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.FINALIZE_CARD_PROCESSING.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(body.toString());
    }

    public static MessageDto getReleaseChannelDto(String sessionId) {
        return new MessageDto().setSessionId(sessionId).setAction(MessageDto.Action.RELEASE_CHANNEL.name()).setServerNodeId("serverNodeId").setClientNodeId("clientNodeId").setBody(null);
    }

    public static CardRequest getACardRequest() {
        String poAid = "A000000291A000000191";
        List<ApduRequest> poApduRequests = Collections.singletonList(new ApduRequest(ByteArrayUtil.fromHex((String)"9000"), true));
        return new CardRequest(poApduRequests);
    }

    public static CardSelectionRequest getACardSelectionRequest() {
        String poAid = "A000000291A000000191";
        return new CardSelectionRequest(CardSelector.builder().aidSelector(CardSelector.AidSelector.builder().aidToSelect(poAid).build()).build());
    }

    public static CardResponse getACardResponse() {
        ApduResponse apdu = new ApduResponse(ByteArrayUtil.fromHex((String)"9000"), new HashSet());
        ApduResponse apdu2 = new ApduResponse(ByteArrayUtil.fromHex((String)"9000"), new HashSet());
        ArrayList<ApduResponse> apduResponses = new ArrayList<ApduResponse>();
        apduResponses.add(apdu);
        apduResponses.add(apdu2);
        return new CardResponse(true, apduResponses);
    }

    public static CardSelectionResponse getACardSelectionResponse() {
        ApduResponse apdu = new ApduResponse(ByteArrayUtil.fromHex((String)"9000"), new HashSet());
        ApduResponse apdu2 = new ApduResponse(ByteArrayUtil.fromHex((String)"9000"), new HashSet());
        AnswerToReset atr = new AnswerToReset(ByteArrayUtil.fromHex((String)"9000"));
        ArrayList<ApduResponse> apduResponses = new ArrayList<ApduResponse>();
        apduResponses.add(apdu);
        apduResponses.add(apdu2);
        return new CardSelectionResponse(new SelectionStatus(atr, null, true), BaseLocalTest.getACardResponse());
    }

    public static void assertMetadataMatches(MessageDto request, MessageDto response) {
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((String)response.getSessionId()).isEqualTo((Object)request.getSessionId());
        Assertions.assertThat((String)response.getLocalReaderName()).isEqualTo((Object)request.getLocalReaderName());
        Assertions.assertThat((String)response.getRemoteReaderName()).isEqualTo((Object)request.getRemoteReaderName());
        Assertions.assertThat((String)response.getClientNodeId()).isEqualTo((Object)request.getClientNodeId());
        Assertions.assertThat((String)response.getServerNodeId()).isEqualTo((Object)request.getServerNodeId());
    }

    public static interface ObservableProxyReader
    extends ProxyReader,
    ObservableReader {
    }
}

