/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed.impl;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.KeypleGsonParser;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.impl.AbstractLocalService;
import org.eclipse.keyple.distributed.impl.BaseLocalTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractLocalServiceTest
extends BaseLocalTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLocalServiceTest.class);
    final String pluginName = "pluginName";
    final CardResponse cardResponse = AbstractLocalServiceTest.getACardResponse();
    final List<CardSelectionResponse> cardSelectionResponses = Lists.newArrayList((Object[])new CardSelectionResponse[]{AbstractLocalServiceTest.getACardSelectionResponse()});
    final KeypleReaderIOException keypleReaderIOException = new KeypleReaderIOException("io exception test");
    final KeypleReaderIOException keypleReaderIOExceptionWithCardResponse;
    final KeypleReaderIOException keypleReaderIOExceptionWithCardResponses;
    AbstractLocalService service;

    public AbstractLocalServiceTest() {
        this.keypleReaderIOException.setCardResponse(this.cardResponse);
        this.keypleReaderIOException.setCardSelectionResponses(this.cardSelectionResponses);
        this.keypleReaderIOExceptionWithCardResponse = new KeypleReaderIOException("io exception test with CardResponse");
        this.keypleReaderIOExceptionWithCardResponse.setCardResponse(this.cardResponse);
        this.keypleReaderIOExceptionWithCardResponses = new KeypleReaderIOException("io exception test with CardResponses");
        this.keypleReaderIOExceptionWithCardResponses.setCardSelectionResponses(this.cardSelectionResponses);
    }

    @Before
    public void setUp() {
        this.init();
        this.service = (AbstractLocalService)Mockito.spy(AbstractLocalService.class);
        PluginFactory pluginFactoryMocked = (PluginFactory)Mockito.mock(PluginFactory.class);
        Plugin pluginMocked = (Plugin)Mockito.mock(Plugin.class);
        ((PluginFactory)Mockito.doReturn((Object)pluginMocked).when((Object)pluginFactoryMocked)).getPlugin();
        ((PluginFactory)Mockito.doReturn((Object)"pluginName").when((Object)pluginFactoryMocked)).getPluginName();
        ((Plugin)Mockito.doReturn((Object)"pluginName").when((Object)pluginMocked)).getName();
        ((Plugin)Mockito.doReturn((Object)this.readerMocked).when((Object)pluginMocked)).getReader("readerName");
        ((Plugin)Mockito.doThrow(KeypleReaderNotFoundException.class).when((Object)pluginMocked)).getReader("readerNameUnknown");
        SmartCardService.getInstance().registerPlugin(pluginFactoryMocked);
    }

    @After
    public void tearDown() {
        SmartCardService.getInstance().unregisterPlugin("pluginName");
    }

    @Test(expected=KeypleReaderNotFoundException.class)
    public void findLocalReader_notFound() {
        this.service.findLocalReader("readerNameUnknown");
    }

    @Test
    public void findLocalReader_Found() {
        ProxyReader seReader = this.service.findLocalReader("readerName");
        Assert.assertNotNull((Object)seReader);
    }

    @Test
    public void transmit_returnsCardResponseDto() {
        ((ProxyReader)Mockito.doReturn((Object)this.cardResponse).when((Object)this.readerMocked)).transmitCardRequest((CardRequest)ArgumentMatchers.any(CardRequest.class), (ChannelControl)ArgumentMatchers.any(ChannelControl.class));
        MessageDto requestDto = AbstractLocalServiceTest.getTransmitDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.TRANSMIT.name());
        Assertions.assertThat((Object)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), CardResponse.class)).isEqualToComparingFieldByField((Object)this.cardResponse);
    }

    @Test
    public void transmit_returnsIoException() {
        ((ProxyReader)Mockito.doThrow((Throwable[])new Throwable[]{this.keypleReaderIOException}).when((Object)this.readerMocked)).transmitCardRequest((CardRequest)ArgumentMatchers.any(CardRequest.class), (ChannelControl)ArgumentMatchers.any(ChannelControl.class));
        MessageDto requestDto = AbstractLocalServiceTest.getTransmitDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.ERROR.name());
        BodyError bodyResponse = (BodyError)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), BodyError.class);
        KeypleReaderIOException error = (KeypleReaderIOException)bodyResponse.getException();
        Assertions.assertThat((List)error.getCardSelectionResponses()).hasSameElementsAs(this.cardSelectionResponses);
        Assertions.assertThat((Object)error.getCardResponse()).isEqualToComparingFieldByField((Object)this.cardResponse);
    }

    @Test
    public void transmitSet_returnsCardResponseDto() {
        ((ProxyReader)Mockito.doReturn(this.cardSelectionResponses).when((Object)this.readerMocked)).transmitCardSelectionRequests((List)ArgumentMatchers.any(List.class), (MultiSelectionProcessing)ArgumentMatchers.any(MultiSelectionProcessing.class), (ChannelControl)ArgumentMatchers.any(ChannelControl.class));
        MessageDto requestDto = AbstractLocalServiceTest.getTransmitCardSelectionsDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.TRANSMIT_CARD_SELECTION.name());
        Assertions.assertThat((Object)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), new TypeToken<List<CardSelectionResponse>>(){}.getType())).isEqualToComparingFieldByField(this.cardSelectionResponses);
    }

    @Test
    public void transmitSet_returnsIoException() {
        ((ProxyReader)Mockito.doThrow((Throwable[])new Throwable[]{this.keypleReaderIOException}).when((Object)this.readerMocked)).transmitCardSelectionRequests((List)ArgumentMatchers.any(List.class), (MultiSelectionProcessing)ArgumentMatchers.any(MultiSelectionProcessing.class), (ChannelControl)ArgumentMatchers.any(ChannelControl.class));
        MessageDto requestDto = AbstractLocalServiceTest.getTransmitCardSelectionsDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.ERROR.name());
        BodyError bodyResponse = (BodyError)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), BodyError.class);
        KeypleReaderIOException error = (KeypleReaderIOException)bodyResponse.getException();
        Assertions.assertThat((List)error.getCardSelectionResponses()).isNotNull();
        Assertions.assertThat((Object)error.getCardResponse()).isNotNull();
    }

    @Test
    public void transmitSet_returnsIoException_withCardResponse() {
        ((ProxyReader)Mockito.doThrow((Throwable[])new Throwable[]{this.keypleReaderIOExceptionWithCardResponse}).when((Object)this.readerMocked)).transmitCardSelectionRequests((List)ArgumentMatchers.any(List.class), (MultiSelectionProcessing)ArgumentMatchers.any(MultiSelectionProcessing.class), (ChannelControl)ArgumentMatchers.any(ChannelControl.class));
        MessageDto requestDto = AbstractLocalServiceTest.getTransmitCardSelectionsDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.ERROR.name());
        BodyError bodyResponse = (BodyError)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), BodyError.class);
        KeypleReaderIOException error = (KeypleReaderIOException)bodyResponse.getException();
        Assertions.assertThat((List)error.getCardSelectionResponses()).isNull();
        Assertions.assertThat((Object)error.getCardResponse()).isEqualToComparingFieldByField((Object)this.cardResponse);
    }

    @Test
    public void transmitSet_returnsIoException_withCardResponses() {
        ((ProxyReader)Mockito.doThrow((Throwable[])new Throwable[]{this.keypleReaderIOExceptionWithCardResponses}).when((Object)this.readerMocked)).transmitCardSelectionRequests((List)ArgumentMatchers.any(List.class), (MultiSelectionProcessing)ArgumentMatchers.any(MultiSelectionProcessing.class), (ChannelControl)ArgumentMatchers.any(ChannelControl.class));
        MessageDto requestDto = AbstractLocalServiceTest.getTransmitCardSelectionsDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.ERROR.name());
        BodyError bodyResponse = (BodyError)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), BodyError.class);
        KeypleReaderIOException error = (KeypleReaderIOException)bodyResponse.getException();
        Assertions.assertThat((List)error.getCardSelectionResponses()).hasSameElementsAs(this.cardSelectionResponses);
        Assertions.assertThat((Object)error.getCardResponse()).isNull();
    }

    @Test
    public void setDefaultSelection() {
        MessageDto requestDto = AbstractLocalServiceTest.getSetDefaultSelectionDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally((ProxyReader)this.observableReaderMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.SET_DEFAULT_SELECTION.name());
        Assertions.assertThat((String)responseDto.getBody()).isNull();
    }

    @Test
    public void isSePresent() {
        ((ProxyReader)Mockito.doReturn((Object)true).when((Object)this.readerMocked)).isCardPresent();
        MessageDto requestDto = AbstractLocalServiceTest.getIsCardPresentDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.IS_CARD_PRESENT.name());
        boolean bodyValue = (Boolean)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), Boolean.class);
        Assertions.assertThat((boolean)bodyValue).isTrue();
    }

    @Test
    public void isContactless() {
        ((ProxyReader)Mockito.doReturn((Object)true).when((Object)this.readerMocked)).isContactless();
        MessageDto requestDto = AbstractLocalServiceTest.getIsContactless("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.IS_READER_CONTACTLESS.name());
        boolean bodyValue = (Boolean)KeypleGsonParser.getParser().fromJson(responseDto.getBody(), Boolean.class);
        Assertions.assertThat((boolean)bodyValue).isTrue();
    }

    @Test
    public void releaseChannelDto() {
        MessageDto requestDto = AbstractLocalServiceTest.getReleaseChannelDto("aSessionId");
        MessageDto responseDto = this.service.executeLocally(this.readerMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.RELEASE_CHANNEL.name());
        Assertions.assertThat((String)responseDto.getBody()).isNull();
    }

    @Test
    public void startSeDetection() {
        MessageDto requestDto = AbstractLocalServiceTest.getStartCardDetection("aSessionId");
        MessageDto responseDto = this.service.executeLocally((ProxyReader)this.observableReaderMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.START_CARD_DETECTION.name());
        Assertions.assertThat((String)responseDto.getBody()).isNull();
    }

    @Test
    public void stopCardDetection() {
        MessageDto requestDto = AbstractLocalServiceTest.getStopCardDetection("aSessionId");
        MessageDto responseDto = this.service.executeLocally((ProxyReader)this.observableReaderMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.STOP_CARD_DETECTION.name());
        Assertions.assertThat((String)responseDto.getBody()).isNull();
    }

    @Test
    public void finalizeCardProcessing() {
        MessageDto requestDto = AbstractLocalServiceTest.getFinalizeCardProcessing("aSessionId");
        MessageDto responseDto = this.service.executeLocally((ProxyReader)this.observableReaderMocked, requestDto);
        AbstractLocalServiceTest.assertMetadataMatches(requestDto, responseDto);
        Assertions.assertThat((String)responseDto.getAction()).isEqualTo((Object)MessageDto.Action.FINALIZE_CARD_PROCESSING.name());
        Assertions.assertThat((String)responseDto.getBody()).isNull();
    }
}

