/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.eclipse.keyple.core.card.command.CardCommand;
import org.eclipse.keyple.core.card.command.exception.KeypleCardCommandException;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.BodyErrorJsonSerializer;
import org.eclipse.keyple.core.util.json.ByteArrayJsonAdapter;
import org.eclipse.keyple.core.util.json.CardCommandJsonAdapter;
import org.eclipse.keyple.core.util.json.KeypleCardCommandExceptionJsonSerializer;
import org.eclipse.keyple.core.util.json.KeypleReaderIOExceptionJsonSerializer;
import org.eclipse.keyple.core.util.json.ThrowableJsonSerializer;

public final class KeypleGsonParser {
    private static Gson parser;
    private static final GsonBuilder gsonBuilder;

    public static Gson getParser() {
        if (parser == null) {
            parser = gsonBuilder.create();
        }
        return parser;
    }

    private KeypleGsonParser() {
    }

    private static GsonBuilder initGsonBuilder() {
        GsonBuilder init = new GsonBuilder();
        init.registerTypeAdapter(byte[].class, (Object)new ByteArrayJsonAdapter()).registerTypeAdapter(CardCommand.class, (Object)new CardCommandJsonAdapter()).registerTypeAdapter(BodyError.class, (Object)new BodyErrorJsonSerializer()).registerTypeHierarchyAdapter(Throwable.class, (Object)new ThrowableJsonSerializer()).registerTypeAdapter(KeypleReaderIOException.class, (Object)new KeypleReaderIOExceptionJsonSerializer()).registerTypeHierarchyAdapter(KeypleCardCommandException.class, (Object)new KeypleCardCommandExceptionJsonSerializer());
        return init;
    }

    public static Gson registerTypeAdapter(Class<?> matchingClass, Object adapter, boolean withSubclasses) {
        if (withSubclasses) {
            gsonBuilder.registerTypeHierarchyAdapter(matchingClass, adapter);
        } else {
            gsonBuilder.registerTypeAdapter(matchingClass, adapter);
        }
        parser = gsonBuilder.create();
        return parser;
    }

    static {
        gsonBuilder = KeypleGsonParser.initGsonBuilder();
    }
}

