/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.eclipse.keyple.core.card.command.CardCommand;
import org.eclipse.keyple.core.util.Assert;

public class CardCommandJsonAdapter
implements JsonSerializer<CardCommand>,
JsonDeserializer<CardCommand> {
    public JsonElement serialize(CardCommand cardCommand, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject output = new JsonObject();
        Assert.getInstance().isTrue(cardCommand.getClass().isEnum(), "CardCommandJsonAdapter works only with enum");
        output.addProperty("name", ((Enum)((Object)cardCommand)).name());
        output.addProperty("class", cardCommand.getClass().getName());
        return output;
    }

    public CardCommand deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String className = jsonElement.getAsJsonObject().get("class").getAsString();
        String name = jsonElement.getAsJsonObject().get("name").getAsString();
        try {
            return (CardCommand)Enum.valueOf(Class.forName(className), name);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Can not parse jsonElement as a CardCommand " + jsonElement.toString());
        }
    }
}

