/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.util.bertlv;

public class Tag {
    private final int tagNumber;
    private final byte tagClass;
    private final TagType tagType;
    private final int tagSize;
    public static final byte UNIVERSAL = 0;
    public static final byte APPLICATION = 1;
    public static final byte CONTEXT = 2;
    public static final byte PRIVATE = 3;

    public Tag(int tagNumber, byte tagClass, TagType tagType, int tagSize) {
        if (tagType == null) {
            throw new IllegalArgumentException("TLV Tag: type is null.");
        }
        if (tagClass < 0 || tagClass > 3) {
            throw new IllegalArgumentException("TLV Tag: unknown tag class.");
        }
        this.tagNumber = tagNumber;
        this.tagClass = tagClass;
        this.tagType = tagType;
        this.tagSize = tagSize;
    }

    public Tag(byte[] binary, int offset) {
        this.tagClass = (byte)((binary[offset] & 0xC0) >>> 6);
        this.tagType = (binary[offset] & 0x20) == 32 ? TagType.CONSTRUCTED : TagType.PRIMITIVE;
        int number = binary[offset] & 0x1F;
        if (number == 31) {
            number = binary[offset + 1];
            this.tagSize = 2;
        } else {
            this.tagSize = 1;
        }
        this.tagNumber = number;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public byte getTagClass() {
        return this.tagClass;
    }

    public TagType getTagType() {
        return this.tagType;
    }

    public int getTagSize() {
        return this.tagSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.tagNumber != tag.tagNumber) {
            return false;
        }
        if (this.tagClass != tag.tagClass) {
            return false;
        }
        if (this.tagSize != tag.tagSize) {
            return false;
        }
        return this.tagType == tag.tagType;
    }

    public int hashCode() {
        int result = this.tagNumber;
        result = 31 * result + this.tagClass;
        result = 31 * result + (this.tagType != null ? this.tagType.hashCode() : 0);
        result = 31 * result + this.tagSize;
        return result;
    }

    public String toString() {
        String tagClassString;
        switch (this.tagClass) {
            case 0: {
                tagClassString = "UNIVERSAL";
                break;
            }
            case 1: {
                tagClassString = "APPLICATION";
                break;
            }
            case 2: {
                tagClassString = "CONTEXT";
                break;
            }
            case 3: {
                tagClassString = "PRIVATE";
                break;
            }
            default: {
                tagClassString = "UNKWOWN";
            }
        }
        return String.format("TAG: size=%d Class=%s, Type=%s, Number=%X", new Object[]{this.tagSize, tagClassString, this.tagType, this.tagNumber});
    }

    public static enum TagType {
        PRIMITIVE,
        CONSTRUCTED;

    }
}

