/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.util.bertlv;

import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.eclipse.keyple.core.util.bertlv.Tag;

public class TLV {
    private Tag tag = new Tag(0, 0, Tag.TagType.PRIMITIVE, 1);
    private int length;
    private final byte[] binary;
    private int position;

    public TLV(byte[] binary) {
        this.binary = binary;
        this.length = 0;
        this.position = 0;
    }

    public boolean parse(Tag tag, int offset) {
        if (tag == null) {
            throw new IllegalArgumentException("TLV parsing: tag can't be null.");
        }
        try {
            this.tag = new Tag(this.binary, offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("TLV parsing: index is too large.");
        }
        this.length = 0;
        if (tag.equals(this.tag)) {
            this.position += this.tag.getTagSize();
            if ((this.binary[offset += this.tag.getTagSize()] & 0xFFFFFF80) == 0) {
                this.length += this.binary[offset];
                ++this.position;
            } else {
                ++this.position;
                for (int following = this.binary[offset] & 0x7F; following > 0; --following) {
                    ++this.position;
                    this.length += this.binary[++offset] & 0xFF;
                    if (following <= 1) continue;
                    this.length <<= 8;
                }
            }
            return true;
        }
        return false;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        return String.format("TAG: %s, LENGTH: %d, VALUE: %s", this.tag.toString(), this.length, ByteArrayUtil.toHex(this.getValue()));
    }

    public byte[] getValue() {
        byte[] value = new byte[this.length];
        System.arraycopy(this.binary, this.position, value, 0, this.length);
        this.position += this.length;
        return value;
    }
}

