/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.util;

import java.util.List;

public final class Assert {
    private static final Assert INSTANCE = new Assert();

    private Assert() {
    }

    public static Assert getInstance() {
        return INSTANCE;
    }

    public Assert notNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        return INSTANCE;
    }

    public Assert notEmpty(String obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        if (obj.isEmpty()) {
            throw new IllegalArgumentException("Argument [" + name + "] is empty.");
        }
        return INSTANCE;
    }

    public Assert notEmpty(List<? extends Object> obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        if (obj.isEmpty()) {
            throw new IllegalArgumentException("Argument [" + name + "] is empty.");
        }
        return INSTANCE;
    }

    public Assert notEmpty(byte[] obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        if (obj.length == 0) {
            throw new IllegalArgumentException("Argument [" + name + "] is empty.");
        }
        return INSTANCE;
    }

    public Assert isTrue(Boolean condition, String name) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition [" + name + "] is null.");
        }
        if (!condition.booleanValue()) {
            throw new IllegalArgumentException("Condition [" + name + "] is false.");
        }
        return INSTANCE;
    }

    public Assert greaterOrEqual(Integer number, int minValue, String name) {
        if (number == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        if (number < minValue) {
            throw new IllegalArgumentException("Argument [" + name + "] has a value [" + number + "] less than [" + minValue + "].");
        }
        return INSTANCE;
    }

    public Assert isEqual(Integer number, int value, String name) {
        if (number == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        if (number != value) {
            throw new IllegalArgumentException("Argument [" + name + "] has a value [" + number + "] not equal to [" + value + "].");
        }
        return INSTANCE;
    }

    public Assert isInRange(Integer number, int minValue, int maxValue, String name) {
        if (number == null) {
            throw new IllegalArgumentException("Argument [" + name + "] is null.");
        }
        if (number < minValue) {
            throw new IllegalArgumentException("Argument [" + name + "] has a value [" + number + "] less than [" + minValue + "].");
        }
        if (number > maxValue) {
            throw new IllegalArgumentException("Argument [" + name + "] has a value [" + number + "] more than [" + maxValue + "].");
        }
        return INSTANCE;
    }
}

