/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.service.event;

import org.eclipse.keyple.core.card.message.DefaultSelectionsResponse;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsResponse;

public final class ReaderEvent {
    private final String pluginName;
    private final String readerName;
    private final DefaultSelectionsResponse defaultResponses;
    private final EventType eventType;

    public ReaderEvent(String pluginName, String readerName, EventType eventType, AbstractDefaultSelectionsResponse defaultSelectionsResponse) {
        this.pluginName = pluginName;
        this.readerName = readerName;
        this.eventType = eventType;
        this.defaultResponses = (DefaultSelectionsResponse)defaultSelectionsResponse;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public AbstractDefaultSelectionsResponse getDefaultSelectionsResponse() {
        return this.defaultResponses;
    }

    public Plugin getPlugin() {
        return SmartCardService.getInstance().getPlugin(this.pluginName);
    }

    public Reader getReader() {
        return this.getPlugin().getReader(this.readerName);
    }

    public static enum EventType {
        CARD_INSERTED,
        CARD_MATCHED,
        CARD_REMOVED,
        UNREGISTERED;

    }
}

