/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.service.event;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class PluginEvent {
    private final String pluginName;
    private final SortedSet<String> readerNames;
    private final EventType eventType;

    public PluginEvent(String pluginName, String readerName, EventType eventType) {
        this.pluginName = pluginName;
        this.readerNames = new TreeSet<String>(Collections.singleton(readerName));
        this.eventType = eventType;
    }

    public PluginEvent(String pluginName, Set<String> readerNames, EventType eventType) {
        this.pluginName = pluginName;
        this.readerNames = new TreeSet<String>(readerNames);
        this.eventType = eventType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public SortedSet<String> getReaderNames() {
        return this.readerNames;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public static enum EventType {
        READER_CONNECTED,
        READER_DISCONNECTED,
        UNREGISTERED;

    }
}

