/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.plugin.AbstractPlugin;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PluginFactory;
import org.eclipse.keyple.core.service.exception.KeyplePluginNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartCardService {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardService.class);
    private static final SmartCardService uniqueInstance = new SmartCardService();
    private final Map<String, Plugin> plugins = new ConcurrentHashMap<String, Plugin>();
    private final Object MONITOR = new Object();

    private SmartCardService() {
    }

    public static SmartCardService getInstance() {
        return uniqueInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin registerPlugin(PluginFactory pluginFactory) {
        if (pluginFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        Object object = this.MONITOR;
        synchronized (object) {
            String pluginName = pluginFactory.getPluginName();
            if (this.plugins.containsKey(pluginName)) {
                throw new IllegalStateException("Plugin has already been registered to the platform : " + pluginName);
            }
            Plugin pluginInstance = pluginFactory.getPlugin();
            if (pluginInstance instanceof AbstractPlugin) {
                logger.info("Registering a new Plugin to the platform : {}", (Object)pluginName);
                ((AbstractPlugin)pluginInstance).register();
            } else {
                logger.info("No registration needed for pool plugin : {}", (Object)pluginName);
            }
            this.plugins.put(pluginName, pluginInstance);
            return pluginInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPlugin(String pluginName) {
        Object object = this.MONITOR;
        synchronized (object) {
            Plugin removedPlugin = this.plugins.remove(pluginName);
            if (removedPlugin != null) {
                if (removedPlugin instanceof AbstractPlugin) {
                    ((AbstractPlugin)removedPlugin).unregister();
                    logger.info("Unregistering a plugin from the platform : {}", (Object)removedPlugin.getName());
                } else {
                    logger.info("Unregistration not needed for pool plugin : {}", (Object)pluginName);
                }
            } else {
                throw new IllegalStateException(String.format("This plugin, %s, is not registered", pluginName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isRegistered(String pluginName) {
        Object object = this.MONITOR;
        synchronized (object) {
            return this.plugins.containsKey(pluginName);
        }
    }

    public synchronized Map<String, Plugin> getPlugins() {
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Plugin getPlugin(String name) {
        Object object = this.MONITOR;
        synchronized (object) {
            Plugin plugin = this.plugins.get(name);
            if (plugin == null) {
                throw new KeyplePluginNotFoundException(name);
            }
            return plugin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        InputStream propertiesIs = null;
        try {
            propertiesIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/keyple-core.properties");
            Properties prop = new Properties();
            prop.load(propertiesIs);
            String version = prop.getProperty("version");
            if (version != null) {
                String string = version;
                return string;
            }
        }
        catch (IOException e) {
            logger.error("Keyple core properties file not found in META_INF");
        }
        finally {
            if (propertiesIs != null) {
                try {
                    propertiesIs.close();
                }
                catch (IOException e) {
                    logger.error("IO Exception when closing properties stream", (Throwable)e);
                }
            }
        }
        return "no-version-found";
    }
}

