/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WaitForStartDetectState
extends AbstractObservableState {
    private static final Logger logger = LoggerFactory.getLogger(WaitForStartDetectState.class);

    WaitForStartDetectState(AbstractObservableLocalReader reader) {
        super(AbstractObservableState.MonitoringState.WAIT_FOR_START_DETECTION, reader);
    }

    WaitForStartDetectState(AbstractObservableLocalReader reader, AbstractMonitoringJob monitoringJob, ExecutorService executorService) {
        super(AbstractObservableState.MonitoringState.WAIT_FOR_START_DETECTION, reader, monitoringJob, executorService);
    }

    @Override
    void onEvent(AbstractObservableLocalReader.InternalEvent event) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] onEvent => Event {} received in currentState {}", new Object[]{this.reader.getName(), event, this.state});
        }
        switch (event) {
            case START_DETECT: {
                this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION);
                break;
            }
            default: {
                logger.warn("[{}] Ignore =>  Event {} received in currentState {}", new Object[]{this.reader.getName(), event, this.state});
            }
        }
    }
}

