/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WaitForCardInsertionState
extends AbstractObservableState {
    private static final Logger logger = LoggerFactory.getLogger(WaitForCardInsertionState.class);

    WaitForCardInsertionState(AbstractObservableLocalReader reader) {
        super(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION, reader);
    }

    WaitForCardInsertionState(AbstractObservableLocalReader reader, AbstractMonitoringJob monitoringJob, ExecutorService executorService) {
        super(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION, reader, monitoringJob, executorService);
    }

    @Override
    void onEvent(AbstractObservableLocalReader.InternalEvent event) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] onEvent => Event {} received in currentState {}", new Object[]{this.reader.getName(), event, this.state});
        }
        switch (event) {
            case CARD_INSERTED: {
                ReaderEvent cardEvent = this.reader.processCardInserted();
                if (cardEvent != null) {
                    this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_SE_PROCESSING);
                    this.reader.notifyObservers(cardEvent);
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] onEvent => Inserted card hasn't matched", (Object)this.reader.getName());
                }
                this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_SE_REMOVAL);
                break;
            }
            case STOP_DETECT: {
                this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_START_DETECTION);
                break;
            }
            case CARD_REMOVED: {
                if (this.reader.getPollingMode() == ObservableReader.PollingMode.REPEATING) {
                    this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION);
                    break;
                }
                this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_START_DETECTION);
                break;
            }
            default: {
                logger.warn("[{}] Ignore =>  Event {} received in currentState {}", new Object[]{this.reader.getName(), event, this.state});
            }
        }
    }
}

