/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalBlocking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartRemovalMonitoringJob
extends AbstractMonitoringJob {
    private static final Logger logger = LoggerFactory.getLogger(SmartRemovalMonitoringJob.class);
    private final WaitForCardRemovalBlocking reader;

    public SmartRemovalMonitoringJob(WaitForCardRemovalBlocking reader) {
        this.reader = reader;
    }

    @Override
    Runnable getMonitoringJob(final AbstractObservableState state) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (SmartRemovalMonitoringJob.this.reader.waitForCardAbsentNative()) {
                        state.onEvent(AbstractObservableLocalReader.InternalEvent.CARD_REMOVED);
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("[{}] waitForCardAbsentNative => return false, task interrupted", (Object)SmartRemovalMonitoringJob.this.reader.getName());
                    }
                }
                catch (RuntimeException e) {
                    ((AbstractObservableLocalReader)((Object)SmartRemovalMonitoringJob.this.reader)).getObservationExceptionHandler().onReaderObservationError(((AbstractReader)((Object)SmartRemovalMonitoringJob.this.reader)).getPluginName(), SmartRemovalMonitoringJob.this.reader.getName(), e);
                }
            }
        };
    }

    @Override
    void stop() {
        this.reader.stopWaitForCardRemoval();
    }
}

