/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionBlocking;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartInsertionMonitoringJob
extends AbstractMonitoringJob {
    private static final Logger logger = LoggerFactory.getLogger(SmartInsertionMonitoringJob.class);
    private final WaitForCardInsertionBlocking reader;

    public SmartInsertionMonitoringJob(WaitForCardInsertionBlocking reader) {
        this.reader = reader;
    }

    @Override
    Runnable getMonitoringJob(final AbstractObservableState state) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("[{}] Invoke waitForCardPresent asynchronously", (Object)SmartInsertionMonitoringJob.this.reader.getName());
                        }
                        boolean isCardPresent = SmartInsertionMonitoringJob.this.reader.waitForCardPresent();
                        try {
                            if (isCardPresent) {
                                state.onEvent(AbstractObservableLocalReader.InternalEvent.CARD_INSERTED);
                            }
                            break;
                        }
                        catch (KeypleReaderIOException e) {
                            logger.warn("[{}] waitForCardPresent => Error while processing card insertion event", (Object)SmartInsertionMonitoringJob.this.reader.getName());
                        }
                    }
                }
                catch (RuntimeException e) {
                    ((AbstractObservableLocalReader)((Object)SmartInsertionMonitoringJob.this.reader)).getObservationExceptionHandler().onReaderObservationError(((AbstractReader)((Object)SmartInsertionMonitoringJob.this.reader)).getPluginName(), SmartInsertionMonitoringJob.this.reader.getName(), e);
                }
            }
        };
    }

    @Override
    void stop() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] stopWaitForCard on reader", (Object)this.reader.getName());
        }
        this.reader.stopWaitForCard();
    }
}

