/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.EnumMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.eclipse.keyple.core.plugin.CardAbsentPingMonitoringJob;
import org.eclipse.keyple.core.plugin.CardPresentMonitoringJob;
import org.eclipse.keyple.core.plugin.DontWaitForCardRemovalDuringProcessing;
import org.eclipse.keyple.core.plugin.SmartInsertionMonitoringJob;
import org.eclipse.keyple.core.plugin.SmartRemovalMonitoringJob;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionAutonomous;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionNonBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardInsertionState;
import org.eclipse.keyple.core.plugin.WaitForCardProcessingState;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalAutonomous;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalDuringProcessing;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalNonBlocking;
import org.eclipse.keyple.core.plugin.WaitForCardRemovalState;
import org.eclipse.keyple.core.plugin.WaitForStartDetectState;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObservableReaderStateService {
    private static final Logger logger = LoggerFactory.getLogger(ObservableReaderStateService.class);
    private final AbstractObservableLocalReader reader;
    private final ExecutorService executorService;
    private final EnumMap<AbstractObservableState.MonitoringState, AbstractObservableState> states;
    private AbstractObservableState currentState;

    ObservableReaderStateService(AbstractObservableLocalReader reader) {
        SmartRemovalMonitoringJob smartRemovalMonitoringJob;
        this.reader = reader;
        this.states = new EnumMap(AbstractObservableState.MonitoringState.class);
        this.executorService = Executors.newSingleThreadExecutor();
        this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_START_DETECTION, new WaitForStartDetectState(this.reader));
        if (reader instanceof WaitForCardInsertionAutonomous) {
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION, new WaitForCardInsertionState(this.reader));
        } else if (reader instanceof WaitForCardInsertionNonBlocking) {
            CardPresentMonitoringJob cardPresentMonitoringJob = new CardPresentMonitoringJob(reader, 200L, true);
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION, new WaitForCardInsertionState(this.reader, cardPresentMonitoringJob, this.executorService));
        } else if (reader instanceof WaitForCardInsertionBlocking) {
            SmartInsertionMonitoringJob smartInsertionMonitoringJob = new SmartInsertionMonitoringJob((WaitForCardInsertionBlocking)((Object)reader));
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_INSERTION, new WaitForCardInsertionState(this.reader, smartInsertionMonitoringJob, this.executorService));
        } else {
            throw new KeypleReaderIOException("Reader should implement implement a WaitForCardInsertion interface.");
        }
        if (reader instanceof WaitForCardRemovalDuringProcessing) {
            smartRemovalMonitoringJob = new SmartRemovalMonitoringJob((WaitForCardRemovalBlocking)((Object)reader));
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_PROCESSING, new WaitForCardProcessingState(this.reader, smartRemovalMonitoringJob, this.executorService));
        } else if (reader instanceof DontWaitForCardRemovalDuringProcessing) {
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_PROCESSING, new WaitForCardProcessingState(this.reader));
        } else {
            throw new KeypleReaderIOException("Reader should implement implement a Wait/DontWait ForCardRemovalDuringProcessing interface.");
        }
        if (reader instanceof WaitForCardRemovalAutonomous) {
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_REMOVAL, new WaitForCardRemovalState(this.reader));
        } else if (reader instanceof WaitForCardRemovalNonBlocking) {
            CardAbsentPingMonitoringJob cardAbsentPingMonitoringJob = new CardAbsentPingMonitoringJob(this.reader);
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_REMOVAL, new WaitForCardRemovalState(this.reader, cardAbsentPingMonitoringJob, this.executorService));
        } else if (reader instanceof WaitForCardRemovalBlocking) {
            smartRemovalMonitoringJob = new SmartRemovalMonitoringJob((WaitForCardRemovalBlocking)((Object)reader));
            this.states.put(AbstractObservableState.MonitoringState.WAIT_FOR_SE_REMOVAL, new WaitForCardRemovalState(this.reader, smartRemovalMonitoringJob, this.executorService));
        } else {
            throw new KeypleReaderIOException("Reader should implement implement a WaitForCardRemoval interface.");
        }
        this.switchState(AbstractObservableState.MonitoringState.WAIT_FOR_START_DETECTION);
    }

    protected final synchronized void onEvent(AbstractObservableLocalReader.InternalEvent event) {
        switch (event) {
            case START_DETECT: {
                this.reader.onStartDetection();
                break;
            }
            case STOP_DETECT: {
                this.reader.onStopDetection();
            }
        }
        this.currentState.onEvent(event);
    }

    public final synchronized void switchState(AbstractObservableState.MonitoringState stateId) {
        if (this.currentState != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Switch currentState from {} to {}", new Object[]{this.reader.getName(), this.currentState.getMonitoringState(), stateId});
            }
            this.currentState.onDeactivate();
        } else if (logger.isTraceEnabled()) {
            logger.trace("[{}] Switch to a new currentState {}", (Object)this.reader.getName(), (Object)stateId);
        }
        this.currentState = this.states.get((Object)stateId);
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] New currentState {}", (Object)this.reader.getName(), (Object)this.currentState.getMonitoringState());
        }
        this.currentState.onActivate();
    }

    protected final synchronized AbstractObservableState getCurrentState() {
        return this.currentState;
    }

    public final synchronized AbstractObservableState.MonitoringState getCurrentMonitoringState() {
        return this.currentState.getMonitoringState();
    }

    final void shutdown() {
        this.executorService.shutdown();
    }
}

